#
import time as TIM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
#
class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
#
class CGCodeHardware():
    #
    def __init__(self, uart):
        self.Uart = uart
        self.Uart.SetCBOnLineReceived(self.CBOnLineReceived)
        self.RxLines = []
        self.State = 0 # Idle EStateInterface.Idle
        self.GCode = None
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 != self.State) #EStateInterface.Idle != self.State)
    #
    def ExecuteGCode(self, gcode):
        ### print('Type[' + str(type(gcode)) + ']')
        self.State = 1
        ResultText = ''
        if ('<class \'Command.CCommand\'>' == str(type(gcode))):
            # print('GCodeHardware : Ignore CComment[' + gcode.Comment + ']')
            # no transmit to Uart
            ResultText = 'Not transmitted : [' + gcode.Comment + ']'
            self.State = 0
            return [True, ResultText]
            #
        elif ('<class \'Command.CGCommand\'>' == str(type(gcode))):
            GCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                GCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            ResultText = GCodeLine
            # debug
            print('GCodeHardware : Transmit G-Command[' + GCodeLine + ']')
            self.Uart.WriteLine(GCodeLine)
            return [True, ResultText]
        elif ('<class \'Command.CMCommand\'>' == str(type(gcode))):
            MCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                MCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            ResultText = MCodeLine
            # debug
            print('GCodeHardware : Transmit M-Command[' + MCodeLine + ']')
            self.Uart.WriteLine(MCodeLine)
            return [True, ResultText]
        else:
            self.State = 0
            return [False, 'Invalid GCode']
    #
    #--------------------------------------------------------------------
    #   Callback - Uart
    #--------------------------------------------------------------------
    def CBOnLineReceived(self, rxline):
        #debug print('>>>>>>>>>>>>>' + rxline + '<<<<<<<<<<<<<<<<<<<<')
        if (0 < len(rxline)):
            if ('Grbl' in rxline):
                # debug print('>>>RxD-Comment{' + rxline + '}')
                pass
            else:
                # debug print('>>>RxData{' + rxline + '}State{' + str(self.State) + '}')
                if (1 == self.State) and ('ok' == rxline):
                    self.State = 2
                elif (2 == self.State) and ('ok' == rxline):
                    self.State = 0
                # NC self.RxLines.append(rxline)
        else:
            HLP.Error('Invalid Line received')
    #
    #
#
#
