#
# ------------------------------------------------------------------
#   FrameGCodePlot2D
# ------------------------------------------------------------------
#   Version: 00V01
#   Date   : 221015
#   Time   : 2016
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import ttk as TTK
#
import random as RND
import numpy as NUM
import matplotlib as MPL
import matplotlib.pyplot as PLT
from matplotlib.animation import FuncAnimation
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
#
#------------------------------------------------------------------
#   Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameGCodePlot2D'
#
NAME_TXTEXT                     = 'TxText'
NAME_COUNTTXENTRIES             = 'CountTxEntries'
MASK_TXENTRY                    = 'Entry'
#
#INIT_TXTEXT                     = 'Hello World!'
#INIT_COUNTTXENTRIES             = '0'
#INIT_TXENTRY                    = ''
#
HEADER_RXCHARACTER              = ''
HEADER_RXLINE                   = 'RXD>'
HEADER_TXLINE                   = 'TXD>'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameGCodePlot2D(TKI.Frame):
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 610, height = 532, \
                           padx = 2, pady = 2, bg = "#F2F2F2")
        self.Parent = self
        #--------------------------------------------------------------
        # Control
        #--------------------------------------------------------------
        F, A = PLT.subplots(figsize=(6, 6), dpi=100)
        # alternative:
        #F = PLT.figure()
        #A = F.add_subplot(111)
        #
        self.Figure = F
        self.Axes = A
        #
        PLT.axis('equal')
        #self.PlotData, = self.Axes.plot([], [], 'ro')
        #
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        self.Canvas.get_tk_widget().pack(side=TKI.TOP, fill=TKI.BOTH, expand=1)
        self.OnInfo = None
        self.VX = []
        self.VY = []
    #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    #
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        # SValue = readinitdata.ReadValueInit(INITDATA_SECTION, NAME_TXTEXT, INIT_TXTEXT)
        # if (0 == len(SValue)):
        #     SValue = INIT_TXTEXT
        # self.cbxTxData.set(SValue)
        #
        #SV = readinitdata.ReadValueInit(INITDATA_SECTION,
        #                                NAME_COUNTTXENTRIES, INIT_COUNTTXENTRIES)
        # CE = int(SV)
        # self.STxData = []
        # for IE in range(0, CE):
        #     SE = MASK_TXENTRY + str(IE)
        #     SValue = readinitdata.ReadValueInit(INITDATA_SECTION,
        #                                         SE, INIT_TXENTRY)
        #     if (SValue not in self.STxData):
        #         self.STxData.append(SValue)
        # self.cbxTxData['values'] = self.STxData
        #
        return True
        #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        # writeinitdata.WriteValue(INITDATA_SECTION, NAME_TXTEXT,
        #                          self.cbxTxData.get())
        # CE = len(self.STxData)
        # writeinitdata.WriteValue(INITDATA_SECTION, NAME_COUNTTXENTRIES, str(CE))
        # for IE in range(0, CE):
        #     SE = MASK_TXENTRY + str(IE)
        #     writeinitdata.WriteValue(INITDATA_SECTION, SE, self.STxData[IE])
        #
        return True
        #
    #---------------------------------------------------------------------
    # Function
    #---------------------------------------------------------------
    def SendCommand(self, gcode):
        # self.AddTxLine(gcode.Text())
        # self.lbxRxData.see('end')
        return
    #
    def SendResult(self, result, message, gcode):
        # self.AddRxLine(message)
        # self.lbxRxData.see('end')
        return
    #
    def Refresh(self, plotdatax, plotdatay, xminimum, xmaximum, yminimum, ymaximum):
        self.Axes.cla()
        self.VX = plotdatax
        self.VY = plotdatay
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_xlim([xminimum, xmaximum])
        self.Axes.set_ylim([yminimum, ymaximum])
        self.Axes.plot(self.VX, self.VY, '-', color='#FF0000', linewidth=0.8)
        self.Axes.plot(self.VX, self.VY, color='#008800', marker='o', linestyle='none')
        self.Canvas.draw()
    #
    #
#
#
################################################################################
