#
import time as TIM
import random as RND
import numpy as NUM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
#
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
#
#---------------------------------------------------------
# Type
#---------------------------------------------------------
class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
#
class CGCodePlot2D():
    #
    def __init__(self):
        self.State = 0 # Idle EStateInterface.Idle
        self.GCode = None
        self.VX = []
        self.VY = []
        self.XL =  0.0
        self.XH = RANGE_X
        self.YL =  0.0
        self.YH = RANGE_X
        self.Counter = 0
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 != self.State)
    #
    def GetVX(self):
        return self.VX
    def GetVY(self):
        return self.VY
    def GetXL(self):
        return self.XL
    def GetXH(self):
        return self.XH
    def GetYL(self):
        return self.YL
    def GetYH(self):
        return self.YH
    #
    def AddGComment(self, code):
        if ('G00' == code) or ('G0' == code):
            return ' ; Rapid Positioning'
        if ('G01' == code) or ('G1' == code):
            return ' ; Cut Line Moving'
        if ('G02' == code) or ('G2' == code):
            return ' ; Cut Arc Clockwise'
        if ('G03' == code) or ('G3' == code):
            return ' ; Cut Arc Counter-Clockwise'
        if ('G17' == code):
            return ' ; Arc in XY-Plane'
        if ('G18' == code):
            return ' ; Arc in XZ-Plane'
        if ('G19' == code):
            return ' ; Arc in YZ-Plane'
        if ('G20' == code):
            return ' ; Unit Inches'
        if ('G21' == code):
            return ' ; Unit Millimeters'
        if ('G40' == code):
            return ' ; Cutter Compensation Off'
        if ('G49' == code):
            return ' ; Cancel Tool Length Offset'
        if ('G53' == code):
            return ' ; Use Machine Coordinates'
        if ('G54' == code):
            return ' ; Activate Saved Origin'
        if ('G80' == code):
            return ' ; Cancel'
        if ('G90' == code):
            return ' ; Mode Absolute'
        if ('G91' == code):
            return ' ; Mode Absolute'
        return ' '
    #
    def AddMComment(self, code):
        if ('M0' == code) or ('M00' == code):
            return ' ; Pause'
        if ('M1' == code) or ('M01' == code):
            return ' ; Pause on StopSwitch'
        if ('M2' == code) or ('M02' == code):
            return ' ; Program End'
        if ('M3' == code) or ('M03' == code):
            return ' ; Start Spindle Clockwise'
        if ('M4' == code) or ('M04' == code):
            return ' ; Start Spindle CounterClockwise'
        if ('M5' == code) or ('M05' == code):
            return ' ; Stop Spindle'
        if ('M6' == code) or ('M06' == code):
            return ' ; Select Tool'
        if ('M8' == code):
            return ' ; Coolant On'
        if ('M9' == code):
            return ' ; Coolant Off'
        if ('M25' == code):
            return ' ; Pause SDCard Execution'
        if ('M30' == code):
            return ' ; Program End'
        if ('M99' == code):
            return ' ; Return from SubProgram'
        return ' '
    #
    def InitialiseGCode(self):
        self.VX = []
        self.VY = []
        self.Counter = RANGE_X
        for I in range(0, 1 + self.Counter):
            X = I
            Y = 10.0 * RND.random()
            self.VX.append(X)
            self.VY.append(Y)
    #
    def ExecuteGCode(self, gcode):
        ### print('Type[' + str(type(gcode)) + ']')
        self.State = 1
        ReportText = ''
        if ('<class \'Command.CCommand\'>' == str(type(gcode))):
            ReportText += 'CComment[' + gcode.Comment + ']'
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CGCommand\'>' == str(type(gcode))):
            GCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                GCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            GCodeLine += self.AddGComment(gcode.Code)
            ReportText += 'CGCode[' + GCodeLine + ']'
            #
            if (RANGE_X <= len(self.VX)):
                del self.VX[0]
                del self.VY[0]
                self.Counter += 1
                X = self.Counter
                Y = 5.0 + (2.0 * RND.random() - 1.0)
                Y += 4.0 * NUM.sin(X / 10.0)
                self.VX.append(X)
                self.VY.append(Y)
                self.XL = self.VX[0] - 1
                self.XH = self.VX[-1] + 1
                self.YL = 0.0
                self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CMCommand\'>' == str(type(gcode))):
            MCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                MCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            MCodeLine += self.AddMComment(gcode.Code)
            ReportText += 'CMCode[' + MCodeLine + ']'
            #
            if (RANGE_X <= len(self.VX)):
                del self.VX[0]
                del self.VY[0]
                self.Counter += 1
                X = self.Counter
                Y = 5.0 + (2.0 * RND.random() - 1.0)
                Y += 4.0 * NUM.sin(X / 10.0)
                self.VX.append(X)
                self.VY.append(Y)
                self.XL = self.VX[0] - 1
                self.XH = self.VX[-1] + 1
                self.YL = 0.0
                self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        else:
            self.State = 0
            return [False, 'Invalid GCode']
    #
    #
#
#
