#
import time as TIM
import random as RND
import numpy as NUM
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Uart as URT
import Parameter as P
import Command as C
import GCodeConverter as GCV
import GCodeReport as GCR
import GCodePlot2D as GCP2D
import GCodeHardware as GCH
#
import WindowMain as WM
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
#
#---------------------------------------------------------
# Field - Global
#---------------------------------------------------------
Rmin = 2.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 32
#
#--------------------------------------------------------------------
#   Callback - Task - GCodeExecution
#--------------------------------------------------------------------
# Execute GCode-File:
def CBTaskGCodeExecutionOnStart(task):
    #-----------------------------------------------------
    # GCodePlot2D
    #-----------------------------------------------------
    if (WindowApplication.FrameSetup.FrameSetupGlobal.GCodePlot2D.get()):
        GCodePlot2D.InitialiseGCode()
    return
def CBTaskGCodeExecutionOnAbort(task):
    print('ExecuteGCodeExecution<<<OnAbort>>>')
    return
def CBTaskGCodeExecutionOnExecute(task):
    FileEntry = 'AR.gcode'
    print('>>> Read GCodeList from File[{0}]:'.format(FileEntry))
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(FileEntry)
    #
    print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
    for GCode in GCodeList:
        #-----------------------------------------------------
        # GCodeReport
        #-----------------------------------------------------
        if (WindowApplication.FrameSetup.FrameSetupGlobal.GCodeReport.get()):
            # !!! WindowApplication.SetFrameTabsheet(WM.FRAMEINDEX_REPORT)
            WindowApplication.FrameGCodeReport.SendCommand(GCode)
            [Result, Message] = GCodeReport.ExecuteGCode(GCode)
            # debug TIM.sleep(0.1)
            WindowApplication.FrameGCodeReport.SendResult(Result, Message, GCode)
            if not(Result):
                HLP.Error(Message)
                break
            while (GCodeReport.IsBusy()):
                pass
        #-----------------------------------------------------
        # Common
        #-----------------------------------------------------
        if not(task.IsBusy()):
            WindowApplication.FrameSetup.FrameSetupGlobal.AbortExecution()
            task.Abort()
            return
        #-----------------------------------------------------
        # GCodePlot2D
        #-----------------------------------------------------
        if (WindowApplication.FrameSetup.FrameSetupGlobal.GCodePlot2D.get()):
            # !!! WindowApplication.SetFrameTabsheet(WM.FRAMEINDEX_PLOT2D)
            WindowApplication.FrameGCodePlot2D.SendCommand(GCode)
            [Result, Message] = GCodePlot2D.ExecuteGCode(GCode)
            SF = 0.2
            X0 = GCodePlot2D.GetXL()
            X1 = GCodePlot2D.GetXH()
            DX = X1 - X0
            Y0 = GCodePlot2D.GetYL()
            Y1 = GCodePlot2D.GetYH()
            DY = Y1 - Y0
            WindowApplication.FrameGCodePlot2D.Refresh(GCodePlot2D.GetVX(),
                                                       GCodePlot2D.GetVY(),
                                                       X0 - SF * DX,
                                                       X1 + SF * DX,
                                                       Y0 - SF * DY,
                                                       Y1 + SF * DY)
            WindowApplication.FrameGCodePlot2D.SendResult(Result, Message, GCode)
            # debug TIM.sleep(0.5)
            if not(Result):
                HLP.Error(Message)
                break
            while (GCodePlot2D.IsBusy()):
                pass
        #-----------------------------------------------------
        # Common
        #-----------------------------------------------------
        if not(task.IsBusy()):
            WindowApplication.FrameSetup.FrameSetupGlobal.AbortExecution()
            task.Abort()
            return
        #-----------------------------------------------------
        # GCodeHardware
        #-----------------------------------------------------
        if (WindowApplication.FrameSetup.FrameSetupGlobal.GCodeHardware.get()):
            # !!! WindowApplication.SetFrameTabsheet(WM.FRAMEINDEX_HARDWARE)
            WindowApplication.FrameGCodeHardware.SendCommand(GCode)
            [Result, Message] = GCodeHardware.ExecuteGCode(GCode)
            WindowApplication.FrameGCodeHardware.SendResult(Result, Message, GCode)
            if not(Result):
                HLP.Error(Message)
                break
            while (GCodeHardware.IsBusy()):
                pass
        #-----------------------------------------------------
        # Common
        #-----------------------------------------------------
        if not(task.IsBusy()):
            WindowApplication.FrameSetup.FrameSetupGlobal.AbortExecution()
            task.Abort()
            return
        #
    print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
    WindowApplication.FrameSetup.FrameSetupGlobal.AbortExecution()
    task.Abort()
    return
#
#--------------------------------------------------------------------
#   Callback - Start/StopEvent Setup
#--------------------------------------------------------------------
def OnButtonStartExecution():
    print('GLOBAL: OnStartExecution')
    TaskExecution.Start()
    return
def OnButtonAbortExecution():
    print('GLOBAL: OnAbortExecution')
    TaskExecution.Abort()
    return
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
GCodeConverter = GCV.CGCodeConverter()
GCodeReport = GCR.CGCodeReport()
GCodePlot2D = GCP2D.CGCodePlot2D()
UartGrblController = URT.CUart()
GCodeHardware = GCH.CGCodeHardware(UartGrblController)
GCodeList = []
TaskExecution = TSK.CTask('TaskExecution',
                          CBTaskGCodeExecutionOnStart,
                          CBTaskGCodeExecutionOnAbort,
                          CBTaskGCodeExecutionOnExecute)
#
#--------------------------------------------------------------------
#   Callback - Main
#--------------------------------------------------------------------
def OnWindowMainDelete():
    try:
        WindowApplication.WriteInitdata(DEF.NAME_INITFILE)
        TaskExecution.Abort()
        UartGrblController.Close()
    except:
        pass
#
#----------------------------------------------
if '__main__' == __name__:
    print("*** " + DEF.APPLICATION_TITLE + ": begin")
    #
    #----------------------------------------------
    # Activate WindowMain
    #----------------------------------------------
    WindowApplication = WM.CWindowMain(OnWindowMainDelete)
    WindowApplication.Initialise(UartGrblController)
    WindowApplication.FrameSetup.FrameSetupGlobal.SetOnStartExecution(OnButtonStartExecution)
    WindowApplication.FrameSetup.FrameSetupGlobal.SetOnAbortExecution(OnButtonAbortExecution)
    #
    # debug !!!
    WindowApplication.FrameSetup.FrameSetupGlobal.GCodePlot2D.set(True)
    #
    # WindowApplication.FrameGCodePlot2D.SetConfiguration(OnRefreshPlot,
        #                                              DEF.PERIOD_REFRESHPLOT_MS,
        #                                              DEF.LIMIT_X_LOW, DEF.LIMIT_X_HIGH,
        #                                              DEF.LIMIT_Y_LOW, DEF.LIMIT_Y_HIGH)
    #----------------------------------------------
    # Start WindowMain
    #----------------------------------------------
    # TaskRefreshData = TSK.CTask('TaskRefreshData',
    #                             OnTaskRefreshDataStart,
    #                             OnTaskRefreshDataAbort,
    #                             OnTaskRefreshDataExecute)
    # TaskRefreshData.Start()
    #
    WindowApplication.Execute()
    #
    #----------------------------------------------
    # Free WindowMain
    #----------------------------------------------
    if (TaskExecution.IsBusy()):
        TaskExecution.Abort()
    if (UartGrblController.IsOpen()):
        UartGrblController.Close()
    # if (TaskRefreshData.IsBusy()):
    #     TaskRefreshData.Abort()

    #
    print("*** " + DEF.APPLICATION_TITLE + ": end")
    #
    #
#
#





# GCodeSimulator.ExecuteGCode(GCode)
# while (GCodeSimulator.IsBusy()): #  or GCodeHardware.IsBusy()):




###########################################################################
#
#


#
#---------------------------------------------------------
# Callback - Task - RefreshData
#---------------------------------------------------------
# def OnTaskRefreshDataStart(task):
#     global VX, VY, Counter
#     print('OnTaskRefreshDataStart[{0}]: begin'.format(task.ID))
#     VX = []
#     VY = []
#     Counter = RANGE_X
#     for I in range(0, 1 + Counter):
#         X = I
#         Y = 10.0 * RND.random()
#         VX.append(X)
#         VY.append(Y)
#     print('OnTaskRefreshDataStart[{0}]: end'.format(task.ID))
#     return
# def OnTaskRefreshDataAbort(task):
#     global VX, VY, Counter
#     print('OnTaskRefreshDataAbort[{0}]: begin'.format(task.ID))
#     print('OnTaskRefreshDataAbort[{0}]: end'.format(task.ID))
#     return
# def OnTaskRefreshDataExecute(task):
#     global VX, VY, Counter
#     # debug print('OnTaskRefreshDataExecute[{0}]: begin'.format(task.ID))
#     if (RANGE_X <= len(VX)):
#         del VX[0]
#         del VY[0]
#         Counter += 1
#         X = Counter
#         Y = 5.0 + (2.0 * RND.random() - 1.0)
#         Y += 4.0 * NUM.sin(X / 10.0)
#         VX.append(X)
#         VY.append(Y)
#         XL = VX[0] - 1
#         XH = VX[-1] + 1
#         YL = 0.0
#         YH = 10.0
#         # !!! Refresh Plot with new data/extrema !!!
#         if (WindowApplication.IsActive):
#             WindowApplication.FrameGCodePlot2D.Refresh(VX, VY, XL, XH, YL, YH)
#         TIM.sleep(0.01)
#     # debug print('OnTaskRefreshDataExecute[{0}]: end'.format(task.ID))
#     return


#def OnRefreshPlot(ticks, xlimitlow, xlimithigh, ylimitlow, ylimithigh):
#     global VX, VY
#     # Refresh Axis Values
#     XLimitLow = DEF.LIMIT_X_LOW
#     XLimitHigh = DEF.LIMIT_X_HIGH
#     YLimitLow = DEF.LIMIT_Y_LOW
#     YLimitHigh = DEF.LIMIT_Y_HIGH
#     LineColor = '#FF0000FF' # (NUM.random.random(), NUM.random.random(), NUM.random.random())
#     # Refresh Plot Values
#     Ticks = ticks % Modulo
#     A = 2 * NUM.pi * Ticks / Modulo
#     R = Rmin + Ticks / Modulo * (Rmax - Rmin)
#     X = DEF.XM + R * NUM.cos(A)
#     Y = DEF.YM + R * NUM.sin(A)
#     VX.append(X)
#     VY.append(Y)
#     if (Modulo - 2 < len(VX)):
#         WindowMain.FrameGCodePlot2D.ResetPlot()
#         VX.pop(0)
#         VY.pop(0)
#     # Plot ... (Only at THIS point! Select here styles!)
#     MainWindow.FrameGCodePlot2D.Plot(VX, VY, LineColor)
#     return [VX, VY, XLimitLow, XLimitHigh, YLimitLow, YLimitHigh]

    #----------------------------------------------
    # Activate Uart (with GRBL-Reset)
    #----------------------------------------------
    # Setup!!! UartGrblController.SetWaitingForLineReceived()
    # UartGrblController.Open('COM9', '115200', 'N', '8', '1', 'None')
    # while (UartGrblController.IsWaitingForLineReceived):
    #     pass


    #----------------------------------------------
    # Load/Convert GCode-File
    #----------------------------------------------
    # Execution!!! FileEntry = 'AAAmini.gcode'
    # print('>>> Read GCodeList from File[{0}]:'.format(FileEntry))
    # [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(FileEntry)
    # #print('>>> GCodeLines:')
    # #print(GCodeLines)
    # print('>>> GCodeList:')
    # print(GCodeList.Text(), end='')
    # #----------------------------------------------
    # # Start GCode-Execution
    # #----------------------------------------------
    # TaskExecution.Start()
