#
import time as TIM
import random as RND
import numpy as NUM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
#
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
#
#---------------------------------------------------------
# Type
#---------------------------------------------------------
class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
#
class CGCodePlot2D():
    #
    def __init__(self):
        self.State = 0 # Idle EStateInterface.Idle
        # Plot
        self.VX = []
        self.VY = []
        self.VZ = [] # NC in Plot2D
        self.XL =  0.0
        self.XH = 10.0
        self.InitX = True
        self.YL =  0.0
        self.YH = 10.0
        self.InitY = True
        self.ZL =  0.0
        self.ZH = 10.0
        self.InitZ = True
        # GCode
        #self.GCode = None
        # self.ParameterX0 =  0.0 # [mm] - PresetX
        # self.ParameterY0 =  0.0 # [mm] - PresetY
        # self.ParameterZ0 =  0.0 # [mm] - PresetZ
        self.ParameterX =   0.0 # [mm]
        self.ParameterY =   0.0 # [mm]
        self.ParameterZ =   0.0 # [mm]
        self.ParameterE =   0.0 # [mm]
        self.ParameterF = 100.0 # [mm/s]
        #self.ParameterH = float(Parameter.Value)
        #self.ParameterR = float(Parameter.Value)
        #self.ParameterS = float(Parameter.Value)
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 != self.State)
    #
    def GetVX(self):
        return self.VX
    def GetVY(self):
        return self.VY
    def GetXL(self):
        return self.XL
    def GetXH(self):
        return self.XH
    def GetYL(self):
        return self.YL
    def GetYH(self):
        return self.YH
    #
    def GCodePlotData(self, code):
        # debug print(code)
        if ('G00' == code) or ('G0' == code):
            self.VX.append(self.ParameterX)
            self.VY.append(self.ParameterY)
            self.VZ.append(self.ParameterZ)
            return ' ; Rapid Positioning'
        if ('G01' == code) or ('G1' == code):
            # debug print(self.ParameterX, self.ParameterY, self.ParameterZ)
            self.VX.append(self.ParameterX)
            self.VY.append(self.ParameterY)
            self.VZ.append(self.ParameterZ)
            return ' ; Cut Line Moving'
        if ('G02' == code) or ('G2' == code):
            self.VX.append(self.ParameterX)
            self.VY.append(self.ParameterY)
            self.VZ.append(self.ParameterZ)
            return ' ; Cut Arc Clockwise'
        if ('G03' == code) or ('G3' == code):
            self.VX.append(self.ParameterX)
            self.VY.append(self.ParameterY)
            self.VZ.append(self.ParameterZ)
            return ' ; Cut Arc Counter-Clockwise'
        if ('G17' == code):
            return ' ; Arc in XY-Plane'
        if ('G18' == code):
            return ' ; Arc in XZ-Plane'
        if ('G19' == code):
            return ' ; Arc in YZ-Plane'
        if ('G20' == code):
            return ' ; Unit Inches'
        if ('G21' == code):
            return ' ; Unit Millimeters'
        if ('G40' == code):
            return ' ; Cutter Compensation Off'
        if ('G49' == code):
            return ' ; Cancel Tool Length Offset'
        if ('G53' == code):
            return ' ; Use Machine Coordinates'
        if ('G54' == code):
            return ' ; Activate Saved Origin'
        if ('G80' == code):
            return ' ; Cancel'
        if ('G90' == code):
            return ' ; Mode Absolute'
        if ('G91' == code):
            return ' ; Mode Absolute'
        return ' '
    #
    def MCodePlotData(self, code):
        if ('M0' == code) or ('M00' == code):
            return ' ; Pause'
        if ('M1' == code) or ('M01' == code):
            return ' ; Pause on StopSwitch'
        if ('M2' == code) or ('M02' == code):
            return ' ; Program End'
        if ('M3' == code) or ('M03' == code):
            return ' ; Start Spindle Clockwise'
        if ('M4' == code) or ('M04' == code):
            return ' ; Start Spindle CounterClockwise'
        if ('M5' == code) or ('M05' == code):
            return ' ; Stop Spindle'
        if ('M6' == code) or ('M06' == code):
            return ' ; Select Tool'
        if ('M8' == code):
            return ' ; Coolant On'
        if ('M9' == code):
            return ' ; Coolant Off'
        if ('M25' == code):
            return ' ; Pause SDCard Execution'
        if ('M30' == code):
            return ' ; Program End'
        if ('M99' == code):
            return ' ; Return from SubProgram'
        return ' '
    #
    def RefreshExtremaX(self, valuex):
        if (self.InitX):
            self.InitX = False
            self.XL = self.XL - self.XL / 10.0
            self.XH = valuex
        else:
            if (valuex < self.XL):
                self.XL = valuex
                return
            if (self.XH < valuex):
                self.XH = valuex
                return
    def RefreshExtremaY(self, valuey):
        if (self.InitY):
            self.InitY = False
            self.YL = self.YL - self.YL / 10.0
            self.YH = valuey
        else:
            if (valuey < self.YL):
                self.YL = valuey
                return
            if (self.YH < valuey):
                self.YH = valuey
                return
    def RefreshExtremaZ(self, valuez):
        if (self.InitZ):
            self.InitZ = False
            self.ZL = self.ZL - self.ZL / 10.0
            self.ZH = valuez
        else:
            if (valuez < self.ZL):
                self.ZL = valuez
                return
            if (self.ZH < valuez):
                self.ZH = valuez
                return
    #
    def BuildGCodeParameter(self, gcode):
        self.GCode = gcode.Code # string
        for Parameter in gcode.Parameterlist:
            if ('X' == Parameter.Code): # float
                self.ParameterX = float(Parameter.Value)
                self.RefreshExtremaX(self.ParameterX)
            elif ('Y' == Parameter.Code): # float
                self.ParameterY = float(Parameter.Value)
                self.RefreshExtremaY(self.ParameterY)
            elif ('Z' == Parameter.Code): # float
                self.ParameterZ = float(Parameter.Value)
                self.RefreshExtremaZ(self.ParameterZ)
            elif ('E' == Parameter.Code): # float
                self.ParameterE = float(Parameter.Value)
            elif ('F' == Parameter.Code): # float
                self.ParameterF = float(Parameter.Value)
            # elif ('H' == Parameter.Code): # float
            #     self.ParameterH = float(Parameter.Value)
            # elif ('R' == Parameter.Code): # float
            #     self.ParameterR = float(Parameter.Value)
            # elif ('S' == Parameter.Code): # float
            #     self.ParameterS = float(Parameter.Value)
    #
    def InitialiseGCode(self):
        # self.VX = []
        # self.VY = []
        # self.Counter = RANGE_X
        # for I in range(0, 1 + self.Counter):
        #     X = I
        #     Y = 10.0 * RND.random()
        #     self.VX.append(X)
        #     self.VY.append(Y)
        return
    #
    def ExecuteGCode(self, gcode):
        ### print('Type[' + str(type(gcode)) + ']')
        self.State = 1
        self.BuildGCodeParameter(gcode)
        ReportText = ''
        if ('<class \'Command.CCommand\'>' == str(type(gcode))):
            # NC? ReportText += 'CComment[' + gcode.Comment + ']'
            # nothing do do...
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CGCommand\'>' == str(type(gcode))):
            #
            self.GCodePlotData(gcode.Code)
            #
            # NC? GCodeLine = gcode.Code
            # NC? for Parameter in gcode.Parameterlist:
            # NC?     GCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            # NC? GCodeLine += self.AddGComment(gcode.Code)
            # NC? ReportText += 'CGCode[' + GCodeLine + ']'
            #
            # if (RANGE_X <= len(self.VX)):
            #     del self.VX[0]
            #     del self.VY[0]
            #     self.Counter += 1
            #     X = self.Counter
            #     Y = 5.0 + (2.0 * RND.random() - 1.0)
            #     Y += 4.0 * NUM.sin(X / 10.0)
            #     self.VX.append(X)
            #     self.VY.append(Y)
            #     self.XL = self.VX[0] - 1
            #     self.XH = self.VX[-1] + 1
            #     self.YL = 0.0
            #     self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CMCommand\'>' == str(type(gcode))):
            #
            self.MCodePlotData(gcode.Code)
            #
            # NC? MCodeLine = gcode.Code
            # NC? for Parameter in gcode.Parameterlist:
            # NC?     MCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            # NC? MCodeLine += self.AddMComment(gcode.Code)
            # NC? ReportText += 'CMCode[' + MCodeLine + ']'
            #
            # if (RANGE_X <= len(self.VX)):
            #     del self.VX[0]
            #     del self.VY[0]
            #     self.Counter += 1
            #     X = self.Counter
            #     Y = 5.0 + (2.0 * RND.random() - 1.0)
            #     Y += 4.0 * NUM.sin(X / 10.0)
            #     self.VX.append(X)
            #     self.VY.append(Y)
            #     self.XL = self.VX[0] - 1
            #     self.XH = self.VX[-1] + 1
            #     self.YL = 0.0
            #     self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        else:
            self.State = 0
            return [False, 'Invalid GCode']
    #
    #
#
#
