#
# ------------------------------------------------------------------
#   FrameSetupUart
# ------------------------------------------------------------------
#   Version: 00V03
#   Date   : 221013
#   Time   : 1047
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import ttk as TTK
#
import Define as DEF
import Helper as HLP
import Uart as URT
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSetupUart'
#
SPACE_COLUMN                    = '    '
TEXT_OPEN                       = 'Open'
TEXT_CLOSE                      = 'Close'
#
NAME_ISOPEN                     = 'IsOpen'
INIT_ISOPEN                     = 'False'
#
STATE_NOUARTS                   = 'nouarts'
STATE_UARTOPEN                  = 'uartopen'
STATE_UARTCLOSE                 = 'uartclose'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
#
class CFrameSetupUart(TKI.Frame):
    # Row0
    btnComport = None
    SComport = None
    cbxComport = None
    lblBaudrate = None
    SBaudrate = None
    cbxBaudrate = None
    # Row1
    lblParity = None
    SParity = None
    cbxParity = None
    lblDatabits = None
    SDatabits = None
    cbxDatabits = None
    # Row2
    lblStopbits = None
    SStopbits = None
    cbxStopbits = None
    lblHandshake = None
    SHandshake = None
    cbxHandshake = None
    # Row3
    btnOpenClose = None
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 640, height = 480, \
                           padx = DEF.PAD_X, pady = DEF.PAD_Y, bg = "#F2F2F2")
        #
        self.Uart = None
        self.CBOnStateUartChanged = None
        #
        # self.grid_propagate(0)
        # self.grid_rowconfigure(0, weight = 1)
        # self.grid_columnconfigure(0, weight = 1)
        # self.grid_rowconfigure(1, weight = 1)
        # self.grid_rowconfigure(2, weight = 1)
        # self.grid_columnconfigure(1, weight = 1)
        # self.grid_columnconfigure(2, weight = 1)
        #--------------------------------------------------------------
        # Controls - Row0
        #--------------------------------------------------------------
        self.btnComport = TKI.Button(self, text = 'Comport',
                                     command = self.OnComportsRefresh)
        self.btnComport.grid(row = 0, column = 0, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SComport = TKI.StringVar()
        self.cbxComport = TTK.Combobox(self, width = 10, state='readonly',
                                        textvariable = self.SComport,
                                        font = ('Courier', 10))
        self.cbxComport.grid(row = 0, column = 1, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.lblSpace0 = TKI.Label(self, text = SPACE_COLUMN)
        self.lblSpace0.grid(row = 0, column = 2, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.lblBaudrate = TKI.Label(self, text = 'Baudrate')
        self.lblBaudrate.grid(row = 0, column = 3, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SBaudrate = TKI.StringVar()
        self.cbxBaudrate = TTK.Combobox(self, width = 10, state='readonly',
                                        textvariable = self.SBaudrate,
                                        font = ('Courier', 10))
        self.cbxBaudrate.grid(row = 0, column = 4, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.cbxBaudrate['values'] = URT.BAUDRATES
        self.cbxBaudrate.current(URT.INDEX_BAUDRATE_DEFAULT)
        #--------------------------------------------------------------
        # Controls - Row1
        #--------------------------------------------------------------
        self.lblParity = TKI.Label(self, text = 'Parity')
        self.lblParity.grid(row = 1, column = 0, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SParity = TKI.StringVar()
        self.cbxParity = TTK.Combobox(self, width = 10, state='readonly',
                                      textvariable = self.SParity,
                                      font = ('Courier', 10))
        self.cbxParity.grid(row = 1, column = 1, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.cbxParity['values'] = URT.PARITIES
        self.cbxParity.current(URT.INDEX_PARITY_DEFAULT)
        #
        self.lblSpace1 = TKI.Label(self, text = SPACE_COLUMN)
        self.lblSpace1.grid(row = 1, column = 2, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.lblDatabits = TKI.Label(self, text = 'Databits')
        self.lblDatabits.grid(row = 1, column = 3, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SDatabits = TKI.StringVar()
        self.cbxDatabits = TTK.Combobox(self, width = 10, state='readonly',
                                      textvariable = self.SDatabits,
                                      font = ('Courier', 10))
        self.cbxDatabits.grid(row = 1, column = 4, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.cbxDatabits['values'] = URT.DATABITS
        self.cbxDatabits.current(URT.INDEX_DATABITS_DEFAULT)
        #--------------------------------------------------------------
        # Controls - Row2
        #--------------------------------------------------------------
        self.lblStopbits = TKI.Label(self, text = 'Stopbits')
        self.lblStopbits.grid(row = 2, column = 0, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SStopbits = TKI.StringVar()
        self.cbxStopbits = TTK.Combobox(self, width = 10, state='readonly',
                                        textvariable = self.SStopbits,
                                        font = ('Courier', 10))
        self.cbxStopbits.grid(row = 2, column = 1, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.cbxStopbits['values'] = URT.STOPBITS
        self.cbxStopbits.current(URT.INDEX_STOPBITS_DEFAULT)
        #
        self.lblSpace2 = TKI.Label(self, text = SPACE_COLUMN)
        self.lblSpace2.grid(row = 2, column = 2, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.lblHandshake = TKI.Label(self, text = 'Handshake')
        self.lblHandshake.grid(row = 2, column = 3, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        self.SHandshake = TKI.StringVar()
        self.cbxHandshake = TTK.Combobox(self, width = 10, state='readonly',
                                      textvariable = self.SHandshake,
                                      font = ('Courier', 10))
        self.cbxHandshake.grid(row = 2, column = 4, padx = DEF.PAD_X, pady = DEF.PAD_Y)
        self.cbxHandshake['values'] = URT.HANDSHAKES
        self.cbxHandshake.current(URT.INDEX_HANDSHAKES_DEFAULT)
        #--------------------------------------------------------------
        # Controls - Row3
        #--------------------------------------------------------------
        self.btnOpenClose = TKI.Button(self, text = 'Open', width = 52,
                                       command = self.OnOpenClose)
        self.btnOpenClose.grid(row = 3, column = 0, columnspan = 5,
                               padx = DEF.PAD_X, pady = DEF.PAD_Y)
        #
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------
    def SetLinkUart(self, uart):
        self.Uart = uart
        self.OnComportsRefresh()
    #
    def SetCBOnStateUartChanged(self, cbonstateuartchanged):
        self.CBOnStateUartChanged = cbonstateuartchanged
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def UartOnOpen(self):
        return
    #
    def UartOnClose(self):
        return
    #
    def UartOnDataReceived(self, rxdata):
        return
    #
    def UartOnLineReceived(self, rxline):
        return
    #---------------------------------------------------------------------
    # Helper
    #---------------------------------------------------------------------
    def ControlsNoComports(self):
        # Row0
        self.btnComport['state'] = TKI.NORMAL
        self.cbxComport['state'] = TKI.DISABLED
        self.lblBaudrate['state'] = TKI.DISABLED
        self.cbxBaudrate['state'] = TKI.DISABLED
        # Row1
        self.lblParity['state'] = TKI.DISABLED
        self.cbxParity['state'] = TKI.DISABLED
        self.lblDatabits['state'] = TKI.DISABLED
        self.cbxDatabits['state'] = TKI.DISABLED
        # Row2
        self.lblStopbits['state'] = TKI.DISABLED
        self.cbxStopbits['state'] = TKI.DISABLED
        self.lblHandshake['state'] = TKI.DISABLED
        self.cbxHandshake['state'] = TKI.DISABLED
        # Row3
        self.btnOpenClose['state'] = TKI.DISABLED
    #
    def ControlsComportOpened(self):
        # Row0
        self.btnComport['state'] = TKI.DISABLED
        self.cbxComport['state'] = TKI.DISABLED
        self.lblBaudrate['state'] = TKI.DISABLED
        self.cbxBaudrate['state'] = TKI.DISABLED
        # Row1
        self.lblParity['state'] = TKI.DISABLED
        self.cbxParity['state'] = TKI.DISABLED
        self.lblDatabits['state'] = TKI.DISABLED
        self.cbxDatabits['state'] = TKI.DISABLED
        # Row2
        self.lblStopbits['state'] = TKI.DISABLED
        self.cbxStopbits['state'] = TKI.DISABLED
        self.lblHandshake['state'] = TKI.DISABLED
        self.cbxHandshake['state'] = TKI.DISABLED
        # Row3
        self.btnOpenClose['state'] = TKI.NORMAL
    #
    def ControlsComportClosed(self):
        # Row0
        self.btnComport['state'] = TKI.NORMAL
        self.cbxComport.configure(state = 'readonly')
        self.lblBaudrate['state'] = TKI.NORMAL
        self.cbxBaudrate.configure(state = 'readonly')
        # Row1
        self.lblParity['state'] = TKI.NORMAL
        self.cbxParity.configure(state = 'readonly')
        self.lblDatabits['state'] = TKI.NORMAL
        self.cbxDatabits.configure(state = 'readonly')
        # Row2
        self.lblStopbits['state'] = TKI.NORMAL
        self.cbxStopbits.configure(state = 'readonly')
        self.lblHandshake['state'] = TKI.NORMAL
        self.cbxHandshake.configure(state = 'readonly')
        # Row3
        self.btnOpenClose['state'] = TKI.NORMAL
    #
    def OnComportsRefresh(self):
        UartsAvailable = URT.FindUartsAvailable()
        self.cbxComport['values'] = UartsAvailable
        if (0 == len(UartsAvailable) or (None == self.Uart)):
            self.cbxComport.set('')
            self.ControlsNoComports()
            if (None != self.CBOnStateUartChanged):
                self.CBOnStateUartChanged(STATE_NOUARTS)
        else:
            if (self.Uart.IsOpen()):
                self.ControlsComportOpened()
            else:
                self.cbxComport.current(0)
                self.ControlsComportClosed()
    #
    def Open(self):
        CP = self.cbxComport.get()
        if (0 < len(CP)):
            BR = self.cbxBaudrate.get()
            PA = self.cbxParity.get()
            DB = self.cbxDatabits.get()
            SB = self.cbxStopbits.get()
            HS = self.cbxHandshake.get()
            self.Uart.Open(CP, BR, PA, DB, SB, HS)
            if (self.Uart.IsOpen()):
                self.btnOpenClose['text'] = TEXT_CLOSE
                self.ControlsComportOpened() # !!!
                if (None != self.CBOnStateUartChanged):
                    self.CBOnStateUartChanged(STATE_UARTOPEN)
    #
    def Close(self):
        self.Uart.Close()
        if not(self.Uart.IsOpen()):
            self.btnOpenClose['text'] = TEXT_OPEN
            self.ControlsComportClosed() # !!!
            if (None != self.CBOnStateUartChanged):
                self.CBOnStateUartChanged(STATE_UARTCLOSE)
    #
    def OnOpenClose(self):
        if (TEXT_OPEN == self.btnOpenClose['text']):
            self.Open()
        else:
            self.Close()
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        IO = readinitdata.ReadValueInit(INITDATA_SECTION, \
                                        NAME_ISOPEN, \
                                        INIT_ISOPEN)
        if (None != self.Uart):
            self.Close()
            if (HLP.StringBoolean(IO)):
                self.Open()
        #
        return True
        #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_ISOPEN, \
                                 HLP.BooleanString(self.Uart.IsOpen()))
        #
        return True
        #
    #
#
#






