#
# ------------------------------------------------------------------
#   GuiMinimal
# ------------------------------------------------------------------
#   Version: 01V01
#   Date   : 200618
#   Time   : 1012
#   Author : OMDevelop
#
import tkinter as TK
from tkinter import ttk as TTK
from tkinter import messagebox as TKMB
from tkinter import filedialog as TKFD
#
import Define as DEF
import Initdata as ID
# import Task as TSK
import FrameSetup as FSU
import FrameUartDataflow as FUD
import FrameGCodeReport as FGR
import FrameGCodePlot2D as FP2
import FrameGCodeHardware as FGH
#
#------------------------------------------------------------------
#   Constant
#------------------------------------------------------------------
FRAMEINDEX_SETUP         = 0
FRAMEINDEX_UARTDATAFLOW  = 1
FRAMEINDEX_REPORT        = 2
FRAMEINDEX_PLOT2D        = 3
FRAMEINDEX_HARDWARE      = 4
#------------------------------------------------------------------
#   Global Type - WindowMain
#------------------------------------------------------------------
class CWindowMain(TK.Tk):
    Uart = None
    #---------------------------------------------------------------------
    # CWindowMain - Constructor
    #---------------------------------------------------------------------
    def __init__(self, onwindowmaindelete):
        super().__init__()
        super().protocol("WM_DELETE_WINDOW", self.OnDeleteWindow)
        #
        self.IsActive = False
        self.OnWindowMainDelete = onwindowmaindelete
        self.Uart = None
        #
        self.title(DEF.APPLICATION_TITLE)
        # self.resizable(False, False)
        #
        # Menu
        self.Menu = TK.Menu(self)
        self.config(menu = self.Menu)
        # Menu - System
        self.MenuSystem = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "System", menu = self.MenuSystem)
        self.MenuSystem.add_command(label = "Read Initfile Default", \
                                    command = self.OnReadInitfileDefault)
        self.MenuSystem.add_command(label = "Read Initfile Dialog", \
                                    command = self.OnReadInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Write Initfile Default", \
                                    command = self.OnWriteInitfileDefault)
        self.MenuSystem.add_command(label = "Write Initfile Dialog", \
                                    command = self.OnWriteInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Exit Application", \
                                    command = self.OnExitApplication)
        # Menu - Device
        self.MenuDevice = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "Protocol", menu = self.MenuDevice)
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolWriteToFile)
        self.MenuDevice.add_separator()
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolClearAll)
        # Menu - Help
        self.MenuHelp = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "Help", menu = self.MenuHelp)
        self.MenuHelp.add_command(label = "Show About", command = self.OnShowAbout)
        #
        #
        #self.grid_propagate(0)
        #
        self.grid_rowconfigure(0, weight = 1)
        self.grid_columnconfigure(0, weight = 1)
        #self.grid_rowconfigure(1, weight = 1)
        #self.grid_rowconfigure(2, weight = 1)
        #self.grid_columnconfigure(1, weight = 1)
        #self.grid_columnconfigure(2, weight = 1)
        #
        #-------------------------------------------------------------------------------
        # Notebook - All
        #-------------------------------------------------------------------------------
        self.nbkMain = TTK.Notebook(self)
        self.nbkMain.grid(sticky = 'WENS')
        #self.nbkMain.pack(fill = TK.BOTH)
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - Setup
        #-------------------------------------------------------------------------------
        self.FrameSetup = FSU.CFrameSetup(self.nbkMain)
        self.nbkMain.add(self.FrameSetup, text = "Setup")
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - UartDataflow
        #-------------------------------------------------------------------------------
        self.FrameUartDataflow = FUD.CFrameUartDataflow(self.nbkMain)
        self.nbkMain.add(self.FrameUartDataflow, text = "UartDataflow")
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - GCodeReport
        #-------------------------------------------------------------------------------
        self.FrameGCodeReport = FGR.CFrameGCodeReport(self.nbkMain)
        self.nbkMain.add(self.FrameGCodeReport, text = "GCodeReport")
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - GCodePlot2D
        #-------------------------------------------------------------------------------
        self.FrameGCodePlot2D = FP2.CFrameGCodePlot2D(self.nbkMain)
        self.nbkMain.add(self.FrameGCodePlot2D, text = "GCodePlot2D")
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - GCodeHardware
        #-------------------------------------------------------------------------------
        self.FrameGCodeHardware = FGH.CFrameGCodeHardware(self.nbkMain)
        self.nbkMain.add(self.FrameGCodeHardware, text = "GCodeHardware")
        #
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def SendFrameGCodeReport(self, reporttext):
        #print(reporttext)
        self.FrameGCodeReport.SendReport(reporttext)
        return
    def SetFrameTabsheet(self, index):
        self.nbkMain.select(index)
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def UartOnOpen(self):
        self.FrameSetup.UartOnOpen()
        self.FrameUartDataflow.UartOnOpen()
    #
    def UartOnClose(self):
        self.FrameSetup.UartOnClose()
        self.FrameUartDataflow.UartOnClose()
    #
    def UartOnDataReceived(self, rxdata):
        self.FrameSetup.UartOnDataReceived(rxdata)
        self.FrameUartDataflow.UartOnDataReceived(rxdata)
    #
    def UartOnLineReceived(self, rxline):
        self.FrameSetup.UartOnLineReceived(rxline)
        self.FrameUartDataflow.UartOnLineReceived(rxline)
    #---------------------------------------------------------------------
    # CApplication - Initdata
    #---------------------------------------------------------------------
    def Initialise(self, uart):
        self.Uart = uart
        self.FrameSetup.SetLinkUart(uart)
        self.FrameUartDataflow.SetLinkUart(uart)
        #
        self.ReadInitdata(DEF.NAME_INITFILE)
        self.IsActive = True
        return
    #
    def ReadInitdata(self, filename):
        print("*** ReadInitdata: start")
        RID = ID.CReadInitdata()
        RID.Open(filename)
        X = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_X, DEF.INIT_X)
        Y = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_Y, DEF.INIT_Y)
        W = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_W, DEF.INIT_W)
        H = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_H, DEF.INIT_H)
        self.geometry('%dx%d+%d+%d' % (int(W), int(H), int(X), int(Y)))
        #
        STI = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, \
                                DEF.INIT_SELECTTABINDEX)
        self.nbkMain.select(int(STI))
        #
        self.FrameGCodeReport.ReadInitdata(RID)
        self.FrameGCodeHardware.ReadInitdata(RID)
        #self.FrameSetup.ReadInitdata(RID)
        #self.FrameUartDataflow.ReadInitdata(RID)
        #
        RID.Close()
        print("*** ReadInitdata: end")
        #
    #
    def WriteInitdata(self, filename):
        print("*** WriteInitdata: begin")
        WID = ID.CWriteInitdata()
        WID.Open(filename)
        X = self.winfo_x()
        Y = self.winfo_y()
        W = self.winfo_width()
        H = self.winfo_height()
        WID.WriteSection(DEF.INITDATA_SECTION)
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_X, str(X))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_Y, str(Y))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_W, str(W))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_H, str(H))
        #
        STI = self.nbkMain.index('current')
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, str(STI))
        #
        self.FrameGCodeReport.WriteInitdata(WID)
        self.FrameGCodeHardware.WriteInitdata(WID)
        #self.FrameSetup.WriteInitdata(WID)
        #self.FrameUartDataflow.WriteInitdata(WID)
        #
        WID.Close()
        print("*** WriteInitdata: end")
        #
    #
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnDeleteWindow(self):
        self.IsActive = False
        # self.WriteInitdata(DEF.NAME_INITFILE)
        self.OnWindowMainDelete()
        super().destroy()
    #
    def OnReadInitfileDefault(self):
        self.ReadInitdata(DEF.NAME_INITFILE)
    #
    def OnReadInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FN = TKFD.askopenfilename(title = 'Read Initfile',
                                  initialdir = '../TerminalUart',
                                  filetypes = FT)
        self.ReadInitdata(FN)
    #
    def OnWriteInitfileDefault(self):
        self.WriteInitdata(DEF.NAME_INITFILE)
    #
    def OnWriteInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.ini',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.WriteInitdata(FN)
    #
    def OnProtocolWriteToFile(self):
        FT = (('Protocolfiles', '*.txt'),
              ('All files', '*.*'))
        FN = DEF.NAME_PROTOCOLFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.txt',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.FrameUartDataflow.SaveProtocolfile(FN)
    #
    def OnProtocolClearAll(self):
        self.FrameUartDataflow.ClearProtocols()
    #
    #---------------------------------------------------------------------
    # CWindowMain - Event
    #---------------------------------------------------------------------
    #
    def OnShowAbout(self):
        TKMB.showinfo("About", DEF.INFO_ABOUT)
    #
    def OnExitApplication(self):
        self.destroy()
    #
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.mainloop()
    #
#
