#
import time as TIM
import random as RND
import numpy as NUM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
#
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
TIME_REFRESH = 0.1
#
#---------------------------------------------------------
# Type
#---------------------------------------------------------
class EStateInterface(Enum):
    Idle = 0
    TransmitCommand = 1
    ReceiveCommand = 2
#
class CGCodePlot2D():
    #
    def __init__(self):
        self.State = 0 # Idle EStateInterface.Idle
        # WorkingParameter
        self.UnitMM = True
        # WorkingPlane
        self.PlaneXY = True
        self.PlaneYZ = False
        self.PlaneZX = False
        self.XS = float(0.0) # [mm] - PresetX
        self.XT = float(0.1) # [mm]
        self.YS = float(0.0) # [mm] - PresetY
        self.YT = float(0.1) # [mm]
        self.ZS = float(0.0) # [mm] - PresetZ
        self.ZT = float(0.1) # [mm]
        # reset:
        self.I = float(0.0) # [mm] # I-Parameter Arc
        self.J = float(0.0) # [mm] # J-Parameter Arc
        self.R = float(0.0) # [mm] # Radius == 0 : IJ->R
        #
        self.E =  float(0.0) # [mm]
        self.FL = float(5.0) # [mm/s] - FeedLow (G1,G2,G3...)
        self.FH = float(30.0) # [mm/s] - FeedHigh (G0)
        # Plot
        self.VX = []
        self.VY = []
        self.VZ = [] # NC in Plot2D
        self.XL =  0.0
        self.XH = 10.0
        self.InitX = True
        self.YL =  0.0
        self.YH = 10.0
        self.InitY = True
        self.ZL =  0.0
        self.ZH = 10.0
        self.InitZ = True
        # GCode
        self.GCode = None
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def IsBusy(self):
        return (0 != self.State)
    #
    def GetVX(self):
        return self.VX
    def GetVY(self):
        return self.VY
    def GetXL(self):
        return self.XL
    def GetXH(self):
        return self.XH
    def GetYL(self):
        return self.YL
    def GetYH(self):
        return self.YH
    #
    # F = D / T -> T = D / F
    #
    def GCodePlotData(self, code):
#----------------------------------------------------------------------
#   G0 - G00
#----------------------------------------------------------------------
        if ('G00' == code) or ('G0' == code):
            X0 = self.XS
            X1 = self.XT
            Y0 = self.YS
            Y1 = self.YT
            D = NUM.sqrt((X1 - X0) * (X1 - X0) + (Y1 - Y0) * (Y1 - Y0))
            T = D / self.FH
            DT = TIME_REFRESH
            NP = int(0.5 + T / DT)
            if (2 <= NP):
                DX = (X1 - X0) / NP
                DY = (Y1 - Y0) / NP
                for PI in range(0, 1 + NP):
                    XI = X0 + DX * PI
                    YI = Y0 + DY * PI
                    self.VX.append(XI)
                    self.VY.append(YI)
                    self.VZ.append(self.ZT)
            else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            self.XS = X1
            self.YS = Y1
            return ' ; Rapid Positioning'
#----------------------------------------------------------------------
#   G1 - G01
#----------------------------------------------------------------------
        if ('G01' == code) or ('G1' == code):
            X0 = self.XS
            X1 = self.XT
            Y0 = self.YS
            Y1 = self.YT
            D = NUM.sqrt((X1 - X0) * (X1 - X0) + (Y1 - Y0) * (Y1 - Y0))
            T = D / self.FL
            DT = TIME_REFRESH
            NP = int(0.5 + T / DT)
            if (2 <= NP):
                DX = (X1 - X0) / NP
                DY = (Y1 - Y0) / NP
                #print('DY[{0}]'.format(DY))
                for PI in range(1, 1 + NP):
                    XI = X0 + DX * PI
                    YI = Y0 + DY * PI
                    #print('I[{0}] YI[{1}]'.format(PI, YI))
                    self.VX.append(XI)
                    self.VY.append(YI)
                    self.VZ.append(self.ZT)
            else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            self.XS = X1
            self.YS = Y1
            return ' ; Cut Line Moving'
#----------------------------------------------------------------------
#   G2 - G02
#----------------------------------------------------------------------
        if ('G02' == code) or ('G2' == code):
            # debug print('~~~>>> G02 <<')
            X0 = self.XS
            X1 = self.XT
            Y0 = self.YS
            Y1 = self.YT
            D2 = NUM.square(X1 - X0) + NUM.square(Y1 - Y0) # later: Arc!!!
            D = NUM.sqrt(D2)
            DT = TIME_REFRESH
            T = D / self.FL
            if (0.0 == self.R): # IJ->R
                # debug print('~~~> G02 - IJ')
                XM = float(X0 + self.I)
                YM = float(Y0 + self.J)
                XD = X0 + (X1 - X0) / 2
                YD = Y0 + (Y1 - Y0) / 2
                WA = HLP.ArcTanPos(Y0 - YM, X0 - XM)
                WB = HLP.ArcTanPos(Y1 - YM, X1 - XM)
                DAB = HLP.PIDRAD - WB + WA
                NP = int(0.5 + T / DT)
                if (2 <= NP):
                    H2 = NUM.square(XD - XM) + NUM.square(YD - YM)
                    R = NUM.sqrt(D2 / 4.0 + H2)
                    for PI in range(0, 1 + NP):
                        SCA = -DAB * PI / NP + WA
                        XI = XM + R * NUM.cos(SCA)
                        YI = YM + R * NUM.sin(SCA)
                        self.VX.append(XI)
                        self.VY.append(YI)
                        self.VZ.append(self.ZT)
                else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            else: # R->IJ
                # debug print('~~~> G02 - R')
                H = NUM.sqrt(NUM.square(self.R) - D2 / 4.0)
                XD = X0 + (X1 - X0) / 2.0
                YD = Y0 + (Y1 - Y0) / 2.0
                WG = HLP.ArcTanPos(Y1 - Y0, X1 - X0)
                XM = XD - H * NUM.sin(WG)
                YM = YD + H * NUM.cos(WG)
                WA = HLP.ArcTanPos(Y0 - YM, X0 - XM)

                WB = HLP.ArcTanPos(Y1 - YM, X1 - XM)
                DAB = HLP.PIDRAD - WB + WA
                NP = int(0.5 + T / DT)
                if (2 <= NP):
                    for PI in range(0, 1 + NP):
                        SCA = -DAB * PI / NP + WA
                        XI = XM + self.R * NUM.cos(SCA)
                        YI = YM + self.R * NUM.sin(SCA)
                        self.VX.append(XI)
                        self.VY.append(YI)
                        self.VZ.append(self.ZT)
                else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            # reset:
            self.XS = X1
            self.YS = Y1
            self.I = 0.0
            self.J = 0.0
            self.R = 0.0
            return ' ; Cut Arc Clockwise'
#----------------------------------------------------------------------
#   G3 - G03
#----------------------------------------------------------------------
        if ('G03' == code) or ('G3' == code):
            # debug print('~~~>>> G03 <<<')
            X0 = self.XS
            X1 = self.XT
            Y0 = self.YS
            Y1 = self.YT
            DT = TIME_REFRESH
            D2 = NUM.square(X1 - X0) + NUM.square(Y1 - Y0) # later: Arc!!!
            D = NUM.sqrt(D2)
            T = D / self.FL
            if (0.0 == self.R): # IJ->R
                # debug print('~~~> G03 - IJ')
                XM = float(X0 + self.I)
                YM = float(Y0 + self.J)
                XD = X0 + (X1 - X0) / 2
                YD = Y0 + (Y1 - Y0) / 2
                WA = HLP.ArcTanPos(Y0 - YM, X0 - XM)
                WB = HLP.ArcTanPos(Y1 - YM, X1 - XM)
                NP = int(0.5 + T / DT)
                if (2 <= NP):
                    H2 = NUM.square(XD - XM) + NUM.square(YD - YM)
                    R = NUM.sqrt(D2 / 4.0 + H2)
                    for PI in range(0, 1 + NP):
                        SCA = (WB - WA) * PI / NP + WA
                        XI = XM + R * NUM.cos(SCA)
                        YI = YM + R * NUM.sin(SCA)
                        self.VX.append(XI)
                        self.VY.append(YI)
                        self.VZ.append(self.ZT)
                else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            else: # R->IJ
                # debug print('~~~> G03 - R')
                H = NUM.sqrt(NUM.square(self.R) - D2 / 4.0)
                XD = X0 + (X1 - X0) / 2.0
                YD = Y0 + (Y1 - Y0) / 2.0
                WG = HLP.ArcTanPos(Y1 - Y0, X1 - X0)
                XM = XD - H * NUM.sin(WG)
                YM = YD + H * NUM.cos(WG)
                WA = HLP.ArcTanPos(Y0 - YM, X0 - XM)
                WB = HLP.ArcTanPos(Y1 - YM, X1 - XM)
                NP = int(0.5 + T / DT)
                if (2 <= NP):
                    for PI in range(0, 1 + NP):
                        SCA = (WB - WA) * PI / NP + WA
                        XI = XM + self.R * NUM.cos(SCA)
                        YI = YM + self.R * NUM.sin(SCA)
                        self.VX.append(XI)
                        self.VY.append(YI)
                        self.VZ.append(self.ZT)
                else:
                    self.VX.append(X1)
                    self.VY.append(Y1)
                    self.VZ.append(self.ZT)
            # reset:
            self.XS = X1
            self.YS = Y1
            self.I = 0.0
            self.J = 0.0
            self.R = 0.0
            return ' ; Cut Arc Counter-Clockwise'
#----------------------------------------------------------------------
#   G17 ...
#----------------------------------------------------------------------
        if ('G17' == code):
            return ' ; Arc in XY-Plane'
        if ('G18' == code):
            return ' ; Arc in XZ-Plane'
        if ('G19' == code):
            return ' ; Arc in YZ-Plane'
        if ('G20' == code):
            return ' ; Unit Inches'
        if ('G21' == code):
            return ' ; Unit Millimeters'
        if ('G40' == code):
            return ' ; Cutter Compensation Off'
        if ('G49' == code):
            return ' ; Cancel Tool Length Offset'
        if ('G53' == code):
            return ' ; Use Machine Coordinates'
        if ('G54' == code):
            return ' ; Activate Saved Origin'
        if ('G80' == code):
            return ' ; Cancel'
        if ('G90' == code):
            return ' ; Mode Absolute'
        if ('G91' == code):
            return ' ; Mode Absolute'
        return ' '
    #
    def MCodePlotData(self, code):
        if ('M0' == code) or ('M00' == code):
            return ' ; Pause'
        if ('M1' == code) or ('M01' == code):
            return ' ; Pause on StopSwitch'
        if ('M2' == code) or ('M02' == code):
            return ' ; Program End'
        if ('M3' == code) or ('M03' == code):
            return ' ; Start Spindle Clockwise'
        if ('M4' == code) or ('M04' == code):
            return ' ; Start Spindle CounterClockwise'
        if ('M5' == code) or ('M05' == code):
            return ' ; Stop Spindle'
        if ('M6' == code) or ('M06' == code):
            return ' ; Select Tool'
        if ('M8' == code):
            return ' ; Coolant On'
        if ('M9' == code):
            return ' ; Coolant Off'
        if ('M25' == code):
            return ' ; Pause SDCard Execution'
        if ('M30' == code):
            return ' ; Program End'
        if ('M99' == code):
            return ' ; Return from SubProgram'
        return ' '
    #
    def RefreshExtremaX(self, valuex):
        if (self.InitX):
            self.InitX = False
            self.XL = self.XL - self.XL / 10.0
            self.XH = valuex
        else:
            if (valuex < self.XL):
                self.XL = valuex
                return
            if (self.XH < valuex):
                self.XH = valuex
                return
    def RefreshExtremaY(self, valuey):
        if (self.InitY):
            self.InitY = False
            self.YL = self.YL - self.YL / 10.0
            self.YH = valuey
        else:
            if (valuey < self.YL):
                self.YL = valuey
                return
            if (self.YH < valuey):
                self.YH = valuey
                return
    def RefreshExtremaZ(self, valuez):
        if (self.InitZ):
            self.InitZ = False
            self.ZL = self.ZL - self.ZL / 10.0
            self.ZH = valuez
        else:
            if (valuez < self.ZL):
                self.ZL = valuez
                return
            if (self.ZH < valuez):
                self.ZH = valuez
                return
    #
    def BuildGCodeParameter(self, gcode):
        self.GCode = gcode.Code # string
        for Parameter in gcode.Parameterlist:
            if ('X' == Parameter.Code): # float
                self.XT = float(Parameter.Value)
                self.RefreshExtremaX(self.XT)
            elif ('Y' == Parameter.Code): # float
                self.YT = float(Parameter.Value)
                self.RefreshExtremaY(self.YT)
            elif ('Z' == Parameter.Code): # float
                self.ZT = float(Parameter.Value)
                self.RefreshExtremaZ(self.ZT)
            elif ('E' == Parameter.Code): # float
                self.E = float(Parameter.Value)
            elif ('F' == Parameter.Code): # float
                self.F = float(Parameter.Value)
            elif ('I' == Parameter.Code): # float
                self.I = float(Parameter.Value)
                #debug print('!!!!!!!!!!!!!!!!!!!! I=', self.I)
            elif ('J' == Parameter.Code): # float
                self.J = float(Parameter.Value)
                #debug print('!!!!!!!!!!!!!!!!!!!! J=', self.J)
            elif ('R' == Parameter.Code): # float
                self.R = float(Parameter.Value)
                #debug
                print('!!!!!!!!!!!!!!!!!!!! R=', self.R)
            # elif ('H' == Parameter.Code): # float
            #     self.H = float(Parameter.Value)
            # elif ('S' == Parameter.Code): # float
            #     self.S = float(Parameter.Value)
    #
    def InitialiseGCode(self):
        # self.VX = []
        # self.VY = []
        # self.Counter = RANGE_X
        # for I in range(0, 1 + self.Counter):
        #     X = I
        #     Y = 10.0 * RND.random()
        #     self.VX.append(X)
        #     self.VY.append(Y)
        return
    #
    def ExecuteGCode(self, gcode):
        ### print('Type[' + str(type(gcode)) + ']')
        self.State = 1
        self.BuildGCodeParameter(gcode)
        ReportText = ''
        if ('<class \'Command.CCommand\'>' == str(type(gcode))):
            # NC? ReportText += 'CComment[' + gcode.Comment + ']'
            # nothing do do...
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CGCommand\'>' == str(type(gcode))):
            #
            self.GCodePlotData(gcode.Code)
            #
            # NC? GCodeLine = gcode.Code
            # NC? for Parameter in gcode.Parameterlist:
            # NC?     GCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            # NC? GCodeLine += self.AddGComment(gcode.Code)
            # NC? ReportText += 'CGCode[' + GCodeLine + ']'
            #
            # if (RANGE_X <= len(self.VX)):
            #     del self.VX[0]
            #     del self.VY[0]
            #     self.Counter += 1
            #     X = self.Counter
            #     Y = 5.0 + (2.0 * RND.random() - 1.0)
            #     Y += 4.0 * NUM.sin(X / 10.0)
            #     self.VX.append(X)
            #     self.VY.append(Y)
            #     self.XL = self.VX[0] - 1
            #     self.XH = self.VX[-1] + 1
            #     self.YL = 0.0
            #     self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        elif ('<class \'Command.CMCommand\'>' == str(type(gcode))):
            #
            self.MCodePlotData(gcode.Code)
            #
            # NC? MCodeLine = gcode.Code
            # NC? for Parameter in gcode.Parameterlist:
            # NC?     MCodeLine += ' ' + str(Parameter.Code) + str(Parameter.Value)
            # NC? MCodeLine += self.AddMComment(gcode.Code)
            # NC? ReportText += 'CMCode[' + MCodeLine + ']'
            #
            # if (RANGE_X <= len(self.VX)):
            #     del self.VX[0]
            #     del self.VY[0]
            #     self.Counter += 1
            #     X = self.Counter
            #     Y = 5.0 + (2.0 * RND.random() - 1.0)
            #     Y += 4.0 * NUM.sin(X / 10.0)
            #     self.VX.append(X)
            #     self.VY.append(Y)
            #     self.XL = self.VX[0] - 1
            #     self.XH = self.VX[-1] + 1
            #     self.YL = 0.0
            #     self.YH = 10.0
            #
            self.State = 0
            return [True, ReportText]
        else:
            self.State = 0
            return [False, 'Invalid GCode']
    #
    #
#
#
