#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import tkinter as TKI
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
import Define as DEF
import Task as TSK
#
#----------------------------------------------------------------------
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        #
        # !!! self.rowconfigure(0, weight=1) #=6
        # self.columnconfigure(0, weight=6)
        # ??? self.FrameParent.grid(row=0, column=0) #, sticky='wnse')
        #
        self.Figure, self.Axes = PLT.subplots(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                                       DEF.DOTS_Y / DEF.DOTSPERINCH),
                                              dpi=DEF.DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self) # not[.FrameParent]!
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='wnse') #
        #
        self.TimePeriod = DEF.TIMEPERIOD_IDLE_MS
        #
        self.VX0 = []
        self.VY0 = []
        self.VX1 = []
        self.VY1 = []
        self.PresetX = []
        self.PresetY = []
        for I in range(0, DEF.RANGE_X):
            self.VX0.append(I)
            self.VY0.append(self.Function(I))
        for I in range(0, DEF.RANGE_X):
            self.VX1.append(I)
            self.VY1.append(DEF.RANGE_X - self.Function(I))
        self.IL = 0
        self.IA = int(DEF.RANGE_X / 2)
        self.IH = DEF.RANGE_X
        self.XL = 0.0
        self.XH = 100.0
        self.YL = 0.0
        self.YH = 100.0
        self.Title = 'Plot2D'
        self.XLabel = 'X [mm]'
        self.YLabel = 'Y [mm]'
        self.LineColor = '#ccccff'
        self.LineStyle = 'solid'
        self.LineWidth = 1.8
        #
        self.Rescale()
        self.RefreshPeriodic()
        return
    # #
    def SetTimePeriodic(self, data):
        self.TimePeriod = data
    #
    # def SetVX(self, data):
    #     self.VX = data.copy()
    # def SetVY(self, data):
    #     self.VY = data.copy()
    #
    def SetXL(self, data):
        self.XL = data
    def SetXH(self, data):
        self.XH = data
    def SetYL(self, data):
        self.YL = data
    def SetYH(self, data):
        self.YH = data
    #
    def SetTitle(self, data):
        self.Title = data
    def SetXLabel(self, data):
        self.XLabel = data
    def SetYLabel(self, data):
        self.YLabel = data
    def SetLineColor(self, data):
        self.LineColor = data
    def SetLineStyle(self, data):
        self.LineStyle = data
    def SetLineWidth(self, data):
        self.LineWidth = data
    #
    def Function(self, x):
        return x
    #
    def Rescale(self):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_title(self.Title)
        self.Axes.set_xlabel(self.XLabel)
        self.Axes.set_ylabel(self.YLabel)
        self.Axes.set_xlim([self.XL, self.XH])
        self.Axes.set_ylim([self.YL, self.YH])
        return
    #
    def RefreshPeriodic(self):
        if (0 < len(self.VX0)):
            self.Rescale()
            self.Axes.plot(self.VX1[self.IA - 1:self.IH],
                           self.VY1[self.IA - 1:self.IH],
                            color='#ff000030',
                            linestyle=self.LineStyle,
                            linewidth=3)
            self.Axes.plot(self.VX1[self.IL:self.IA],
                           self.VY1[self.IL:self.IA],
                            color='#ff0000',
                            linestyle=self.LineStyle,
                            linewidth=3)
            self.Axes.plot(self.VX0, self.VY0,
                            color='#0000ff',
                            linestyle=self.LineStyle,
                            linewidth=3)
            self.Canvas.draw()
        self.FrameParent.after(self.TimePeriod, self.RefreshPeriodic)
        return
    #
    def Refresh(self, vx0, vy0, vx1, vy1, il, ia, ih, timeperiodic):
        self.TimePeriod = timeperiodic
        self.IL = il
        self.IA = ia
        self.IH = ih
        self.VX0 = vx0.copy()
        self.VY0 = vy0.copy()
        self.VX1 = vx1.copy()
        self.VY1 = vy1.copy()
        return
    #
    def Idle(self):
        self.TimePeriod = DEF.TIMEPERIOD_PLOT_MS
        return
    #
#
#
