#
import time as TIM
import numpy as NUM
#
import Define as DEF
import Helper as HLP
import Task as TSK
#
import GCodeConverter as GCV
import GCodeSimulator as GCS
#
#---------------------------------------------------------
# Field - 3D
#---------------------------------------------------------
VX3D = []
VY3D = []
VZ3D = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 32 # 1024
Direction = True
GlobalTicks = 0
Azimuth = HLP.DegRad(30.0)
Elevation = HLP.DegRad(30.0)
#
class CGCodeExecutor():
    #
    def __init__(self):
        self.EventDisplayReady = TSK.CEvent()
        self.TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                             self.OnTaskDisplayPlotdataStart,
                                             self.OnTaskDisplayPlotdataAbort,
                                             self.OnTaskDisplayPlotdataExecute)
        self.TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                            self.OnTaskCreatePlotdataStart,
                                            self.OnTaskCreatePlotdataAbort,
                                            self.OnTaskCreatePlotdataExecute)
        self.GCodeSimulator = GCS.CGCodeSimulator()
        self.GCodeConverter = GCV.CGCodeConverter()
        self.FileEntry = ''
        self.EventDisplayReady = TSK.CEvent()
        self.EventDisplayReady.Set()
        self.FramePlot2D = None
        self.FramePlot3D = None
        return
    #
    #---------------------------------------------------------
    # Callback - Task - Refresh
    #---------------------------------------------------------
    def OnTaskDisplayPlotdataStart(self, task):
        # debug print('### OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
        self.EventDisplayReady.Clear()
        # debug print('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
        return
    def OnTaskDisplayPlotdataAbort(self, task):
        # debug print('##### OnTaskDisplayPlotdataAbort[{0}]: begin                            '.format(task.ID))
        # debug print('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
        return
    #
    def OnTaskDisplayPlotdataExecute(self, task):
        # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin                                          '.format(task.ID))
        # try:
        T0 = TIM.time()
        T1 = T0
        IL = 0
        IH = max(1, len(self.GCodeSimulator.GetVX1()) - 1)
        IA = 0
        Loop = True
        while (Loop):
            if ((T1 + DEF.TIME_REFRESH) < TIM.time()):
                T1 = T1 + DEF.TIME_REFRESH
                #----------------------------------------
                # Plot2D
                #----------------------------------------
                IA = min(IH, 1 + IA)
                XL = self.GCodeSimulator.GetXL()
                XH = self.GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = self.GCodeSimulator.GetYL()
                YH = self.GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                self.FramePlot2D.SetXL(XL)
                self.FramePlot2D.SetXH(XH)
                self.FramePlot2D.SetYL(YL)
                self.FramePlot2D.SetYH(YH)
                self.FramePlot2D.Refresh(self.GCodeSimulator.GetVX0(),
                                         self.GCodeSimulator.GetVY0(),
                                         self.GCodeSimulator.GetVX1(),
                                         self.GCodeSimulator.GetVY1(),
                                         IL, IA, IH, 1)
                TIM.sleep(self.GCodeSimulator.GetTP() / IH)
                #----------------------------------------
                # Plot3D
                #----------------------------------------
                global VX3D, VY3D, VZ3D
                global Azimuth, Elevation
                VX3D = self.GCodeSimulator.GetVX0()
                VY3D = self.GCodeSimulator.GetVY0()
                VZ3D = self.GCodeSimulator.GetVZ0()
                ZL = self.GCodeSimulator.GetZL()
                ZH = self.GCodeSimulator.GetZH()
                DZT = (ZH - ZL) / 10.0
                ZL -= DZT
                ZH += DZT
                self.FramePlot3D.SetVX(VX3D)
                self.FramePlot3D.SetVY(VY3D)
                self.FramePlot3D.SetVZ(VZ3D)
                self.FramePlot3D.SetXL(XL)
                self.FramePlot3D.SetXH(XH)
                self.FramePlot3D.SetYL(YL)
                self.FramePlot3D.SetYH(YH)
                self.FramePlot3D.SetZL(ZL)
                self.FramePlot3D.SetZH(ZH)
                Elevation += HLP.DegRad(5.0)
                Azimuth += HLP.DegRad(10.0)
                self.FramePlot3D.SetElevation(Elevation)
                self.FramePlot3D.SetAzimuth(Azimuth)
                self.FramePlot3D.Refresh(self.GCodeSimulator.GetVX0(),
                                         self.GCodeSimulator.GetVY0(),
                                         self.GCodeSimulator.GetVZ0(),
                                         self.GCodeSimulator.GetVX1(),
                                         self.GCodeSimulator.GetVY1(),
                                         self.GCodeSimulator.GetVZ1(),
                                         IL, IA, IH, 1)
            else:
                TIM.sleep(0.001)
            if (self.GCodeSimulator.GetTP() <= (T1 - T0)):
                Loop = False
            #
        self.FramePlot2D.Idle()
        self.EventDisplayReady.Set()
        # debug  print('OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
        # except:
        #     print('Error: Executing Display')
        return False
    #---------------------------------------------------------
    # Callback - Task - Action
    #---------------------------------------------------------
    def OnTaskCreatePlotdataStart(self, task):
        return
    def OnTaskCreatePlotdataAbort(self, task):
        if (self.TaskDisplayPlotdata.IsBusy()):
            self.TaskDisplayPlotdata.Abort()
        return
    def OnTaskCreatePlotdataExecute(self, task):
        print('>>> Read GCodeList from File[{0}]:'.format(self.FileEntry))
        [GCodeList, GCodeLines] = self.GCodeConverter.ReadFromFile(self.FileEntry)
        print(GCodeList.Text())
        print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
        for GCode in GCodeList:
            self.GCodeSimulator.ExecuteGCode(GCode)
            self.TaskDisplayPlotdata.Start()
            self.EventDisplayReady.Wait()
        print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
        return False
    #
    #---------------------------------------------------------
    # Handler
    #---------------------------------------------------------
    def Init(self, frameplot2d, frameplot3d):
        self.FramePlot2D = frameplot2d
        self.FramePlot3D = frameplot3d
    #
    def Start(self, fileentry):
        self.FileEntry = fileentry
        self.TaskCreatePlotdata.Start()
        return
    #
    def Abort(self):
        if (self.TaskCreatePlotdata.IsBusy()):
            self.TaskCreatePlotdata.Abort()
        return
    #
    #
#
#
