import tkinter as TKI
from tkinter import ttk as TTK
from tkinter import messagebox as TKMB
from tkinter import filedialog as TKFD
#
import Define as DEF
import Initdata as ID
import FrameState as FST
import FrameCommand as FCMD
import FramePlot2D as FP2D
import FramePlot3D as FP3D
import FrameProtocol as FPC
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #
        self.FrameParent.geometry('804x626+66+66')
        #self.FrameParent.geometry('804x626+2022+33')
        self.FrameParent.title(DEF.APPLICATION_TITLE)
        #--------------------------------------------------------
        # Menu
        #--------------------------------------------------------
        self.IsActive = False
        #--------------------------------------------------------
        # Menu
        #--------------------------------------------------------
        self.Menu = TKI.Menu(self.FrameParent)
        self.FrameParent.config(menu = self.Menu)
        # Menu - System
        self.MenuSystem = TKI.Menu(self.Menu)
        self.Menu.add_cascade(label = "System", menu = self.MenuSystem)
        self.MenuSystem.add_command(label = "Read Initfile Default", \
                                    command = self.OnReadInitfileDefault)
        self.MenuSystem.add_command(label = "Read Initfile Dialog", \
                                    command = self.OnReadInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Write Initfile Default", \
                                    command = self.OnWriteInitfileDefault)
        self.MenuSystem.add_command(label = "Write Initfile Dialog", \
                                    command = self.OnWriteInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Exit Application", \
                                    command = self.OnExitApplication)
        # Menu - Device
        # self.MenuDevice = TKI.Menu(self.Menu)
        # self.Menu.add_cascade(label = "Protocol", menu = self.MenuDevice)
        # self.MenuDevice.add_command(label = "Write to File",
        #                             command = self.OnProtocolWriteToFile)
        # self.MenuDevice.add_separator()
        # self.MenuDevice.add_command(label = "Clear All",
        #                             command = self.OnProtocolClearAll)
        # Menu - Help
        self.MenuHelp = TKI.Menu(self.Menu)
        self.Menu.add_cascade(label = "Help", menu = self.MenuHelp)
        self.MenuHelp.add_command(label = "Show About", command = self.OnShowAbout)
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        #self.FrameParent.rowconfigure(0, weight=1)
        #self.FrameParent.columnconfigure(0, weight=1)
        #--------------------------------------------------------
        # FrameState (00)
        #--------------------------------------------------------
        self.frmState = FST.CFrameState(self.FrameParent)
        self.frmState.place(x=0, y=0, width=200, height=800)
        #--------------------------------------------------------
        # Notebook - View (01)
        #--------------------------------------------------------
        self.ntbMain = TTK.Notebook(self.FrameParent)
        self.ntbMain.place(x=203, y=0, width=800, height=600)
        #--------------------------------------------------------
        # Notebook - Tabsheet - Protocol
        #--------------------------------------------------------
        self.tbsProtocol = FPC.CFrameProtocol(self.ntbMain)
        self.ntbMain.add(self.tbsProtocol, text='Protocol')
        #--------------------------------------------------------
        # Notebook - Tabsheet - Plot3D
        #--------------------------------------------------------
        self.tbsPlot3D = FP3D.CFramePlot3D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot3D, text='Plot3D')
        #--------------------------------------------------------
        # Notebook - Tabsheet - Plot2D
        #--------------------------------------------------------
        self.tbsPlot2D = FP2D.CFramePlot2D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot2D, text='Plot2D')
        #--------------------------------------------------------
        # FrameCommand (11)
        #--------------------------------------------------------
        self.frmCommand = FCMD.CFrameCommand(self.FrameParent)
        self.frmCommand.place(x=200, y=600, width=800, height=200)
        #
        return
    #---------------------------------------------------------------------
    # CApplication - Initdata
    #---------------------------------------------------------------------
    def Initialise(self, uart):
        self.Protocol('CFrameApplication.Initialise')
        # self.Uart = uart
        # self.FrameSetup.SetLinkUart(uart)
        # self.FrameUartDataflow.SetLinkUart(uart)
        #
        self.ReadInitdata(DEF.NAME_INITFILE)
        self.IsActive = True
        return
    #
    def ReadInitdata(self, filename):
        self.Protocol('CFrameApplication.ReadInitdata: begin')
        RID = ID.CReadInitdata()
        RID.Open(filename)
        X = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_X, DEF.INIT_X)
        Y = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_Y, DEF.INIT_Y)
        W = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_W, DEF.INIT_W)
        H = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_H, DEF.INIT_H)
        self.FrameParent.geometry('%dx%d+%d+%d' % (int(W), int(H), int(X), int(Y)))
        #
        STI = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX,
                                DEF.INIT_SELECTTABINDEX)
        self.ntbMain.select(int(STI))
        # #
        # self.FrameGCodeReport.ReadInitdata(RID)
        # self.FrameGCodeHardware.ReadInitdata(RID)
        # #self.FrameSetup.ReadInitdata(RID)
        # #self.FrameUartDataflow.ReadInitdata(RID)
        #
        RID.Close()
        self.Protocol('CFrameApplication.ReadInitdata: end')
        return
    #
    def WriteInitdata(self, filename):
        self.Protocol('CFrameApplication.WriteInitdata: begin')
        WID = ID.CWriteInitdata()
        WID.Open(filename)
        X = self.FrameParent.winfo_x()
        Y = self.FrameParent.winfo_y()
        W = self.FrameParent.winfo_width()
        H = self.FrameParent.winfo_height()
        WID.WriteSection(DEF.INITDATA_SECTION)
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_X, str(X))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_Y, str(Y))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_W, str(W))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_H, str(H))
        #
        STI = self.ntbMain.index('current')
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, str(STI))
        # #
        # self.FrameGCodeReport.WriteInitdata(WID)
        # self.FrameGCodeHardware.WriteInitdata(WID)
        # #self.FrameSetup.WriteInitdata(WID)
        # #self.FrameUartDataflow.WriteInitdata(WID)

        WID.Close()
        self.Protocol('CFrameApplication.WriteInitdata: end')
        return
    #---------------------------------------------------------------------
    # CWindowMain - Helper
    #---------------------------------------------------------------------
    def Protocol(self, line):
        if self.IsActive:
            self.tbsProtocol.Line(line)
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        self.IsActive = False
        self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnReadInitfileDefault(self):
        self.ReadInitdata(DEF.NAME_INITFILE)
    #
    def OnReadInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FN = TKFD.askopenfilename(title = 'Read Initfile',
                                  initialdir = '../TerminalUart',
                                  filetypes = FT)
        self.ReadInitdata(FN)
    #
    def OnWriteInitfileDefault(self):
        self.WriteInitdata(DEF.NAME_INITFILE)
    #
    def OnWriteInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.ini',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.WriteInitdata(FN)
    #
    #def OnProtocolWriteToFile(self):
    #    FT = (('Protocolfiles', '*.txt'),
    #           ('All files', '*.*'))
    #     FN = DEF.NAME_PROTOCOLFILE
    #     FF = TKFD.asksaveasfile(initialfile = FN,
    #                             defaultextension = '.txt',
    #                             filetypes = FT)
    #     if (None != FF):
    #         FN = FF.name
    #         FF.close()
    #         self.FrameUartDataflow.SaveProtocolfile(FN)
    # #
    # def OnProtocolClearAll(self):
    #     self.FrameUartDataflow.ClearProtocols()
    #
    #---------------------------------------------------------------------
    # CWindowMain - Event
    #---------------------------------------------------------------------
    #
    def OnShowAbout(self):
        TKMB.showinfo("About", DEF.INFO_ABOUT)
    #
    def OnExitApplication(self):
        self.OnWMDeleteWindow()
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
    #
    #
#
#
