import tkinter as TKI
from PIL import Image, ImageTk
from enum import Enum as ENM
#
class EStateSpindle(ENM):
    sbIdleCW = 0
    sbBusyCW = 1
    sbIdleCCW = 2
    sbBusyCCW = 3
#
class CFrameSpindle(TKI.Frame):
    def __init__(self, frameparent,
                 width, height, sizex, sizey):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        #
        self.HeaderIdle = 'Spindle: OFF'
        self.CommandIdle = 'Set Idle'
        self.HeaderBusyCW = 'Spindle: CW'
        self.CommandBusyCW = 'Rotate CW'
        self.HeaderBusyCCW = 'Spindle: CCW'
        self.CommandBusyCCW = 'Rotate CCW'
        #
        self.SX = width
        self.SY = height
        self.DY = 24
        #
        self.lblHeader = TKI.Label(self, text=self.HeaderIdle)
        self.lblHeader.place(x=0, y=0, width=self.SX,
                             height=self.DY, anchor='nw')
        #
        self.btnCommand = TKI.Button(self, text=self.CommandIdle,
                                     command=self.OnButtonClick)
        self.btnCommand.place(x=0, y=self.SY, width=self.SX,
                              height=self.DY, anchor='sw')
        #
        IMGIdle = Image.open("ressource/spindleidle.png").resize((sizex, sizey), Image.NEAREST)
        self.imgIdle = ImageTk.PhotoImage(IMGIdle)
        IMGBusyCW = Image.open("ressource/spindlebusycw.png").resize((sizex, sizey), Image.NEAREST)
        self.imgBusyCW = ImageTk.PhotoImage(IMGBusyCW)
        IMGBusyCCW = Image.open("ressource/spindlebusyccw.png").resize((sizex, sizey), Image.NEAREST)
        self.imgBusyCCW = ImageTk.PhotoImage(IMGBusyCCW)
        #
        self.lblImage = TKI.Label(self)
        self.lblImage.place(x=0, y=self.DY, width=self.SX, height=self.SY-2*self.DY)
        #
        self.SetState(EStateSpindle.sbIdleCW)
        return
    #
    def SetState(self, state):
        self.State = state
        if (EStateSpindle.sbIdleCW == state):
            self.lblImage['image'] = self.imgIdle
            self.lblHeader['text'] = self.HeaderIdle
            self.btnCommand['text'] = self.CommandBusyCW
        if (EStateSpindle.sbBusyCW == state):
            self.lblImage['image'] = self.imgBusyCW
            self.lblHeader['text'] = self.HeaderBusyCW
            self.btnCommand['text'] = self.CommandIdle
            return
        if (EStateSpindle.sbIdleCCW == state):
            self.lblImage['image'] = self.imgIdle
            self.lblHeader['text'] = self.HeaderIdle
            self.btnCommand['text'] = self.CommandBusyCCW
            return
        if (EStateSpindle.sbBusyCCW == state):
            self.lblImage['image'] = self.imgBusyCCW
            self.lblHeader['text'] = self.HeaderBusyCCW
            self.btnCommand['text'] = self.CommandIdle
            return

    #
    def OnButtonClick(self):
        if (EStateSpindle.sbIdleCW == self.State):
            self.SetState(EStateSpindle.sbBusyCW)
        elif (EStateSpindle.sbBusyCW == self.State):
            self.SetState(EStateSpindle.sbIdleCCW)
        elif (EStateSpindle.sbIdleCCW == self.State):
            self.SetState(EStateSpindle.sbBusyCCW)
        elif (EStateSpindle.sbBusyCCW == self.State):
            self.SetState(EStateSpindle.sbIdleCW)
        return
    #
    #
#
#

