#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
import GCodeExecutor as GEX
import GCodeHardware as GCH
#
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnPositionXMoveAbsolute(positionactual, positiontarget):
    print('PX : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionXMoveRelative(positionactual, positiontarget):
    print('PX : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionYMoveAbsolute(positionactual, positiontarget):
    print('PY : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionYMoveRelative(positionactual, positiontarget):
    print('PY : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionZMoveAbsolute(positionactual, positiontarget):
    print('PZ : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionZMoveRelative(positionactual, positiontarget):
    print('PZ : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnSpindleRotateIdle():
    print('SP : RotateIdle')
    return
def OnSpindleRotateCW(speed):
    print('SP : RotateCW[{0}]'.format(speed))
    return
def OnSpindleRotateCCW(speed):
    print('SP : RotateCCW[{0}]'.format(speed))
    return
#
#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def Protocol(line):
    FrameApplication.Protocol(line)
#--------------------------------------------------------------------
# Callback - Main
#--------------------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        GCodeExecutor.Abort()
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnStartExecution(None)
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnAbortExecution(None)
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
        # NC if (None != TaskExecution):
        # if (TaskExecution.IsBusy()):
        #     TaskExecution.Abort()
        UartGrblController.Close()
    except:
        pass
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
#GCodeConverter = GCV.CGCodeConverter()
#GCodeReport = GCR.CGCodeReport()
#GCodePlot2D = GCP2D.CGCodePlot2D()
UartGrblController = URT.CUart()
GCodeHardware = GCH.CGCodeHardware(UartGrblController)
#GCodeList = []
#TaskExecution = TSK.CTask('TaskExecution',
#                          CBTaskGCodeExecutionOnStart,
#                          CBTaskGCodeExecutionOnAbort,
#                          CBTaskGCodeExecutionOnExecute)

FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.Initialise(UartGrblController)
#
PositionX = FrameApplication.frmCommands.frmPositions.frmPositionX
PositionX.SetOnMoveAbsolute(OnPositionXMoveAbsolute)
PositionX.SetOnMoveRelative(OnPositionXMoveRelative)
#
PositionY = FrameApplication.frmCommands.frmPositions.frmPositionY
PositionY.SetOnMoveAbsolute(OnPositionYMoveAbsolute)
PositionY.SetOnMoveRelative(OnPositionYMoveRelative)
#
PositionZ = FrameApplication.frmCommands.frmPositions.frmPositionZ
PositionZ.SetOnMoveAbsolute(OnPositionZMoveAbsolute)
PositionZ.SetOnMoveRelative(OnPositionZMoveRelative)
#
Spindle = FrameApplication.frmCommands.frmSpindles.frmSpindle
Spindle.SetOnRotateIdle(OnSpindleRotateIdle)
Spindle.SetOnRotateCW(OnSpindleRotateCW)
Spindle.SetOnRotateCCW(OnSpindleRotateCCW)
#
GCodeExecutor = GEX.CGCodeExecutor(Protocol)
GCodeExecutor.Initialise(FrameApplication.tbsPlot2D,
                         FrameApplication.tbsPlot3D)
#
#----------------------------------------------
#   Main
#----------------------------------------------
if ('__main__' == __name__):
    print("*** " + DEF.APPLICATION_TITLE + ": begin")
    #
    FrameApplication.Initialise(UartGrblController)
    #
    ### GCodeExecutor.Start('AR.gcode')
    #
    FrameApplication.Execute()
    #
    # if (UartGrblController.IsOpen()):
    #     UartGrblController.Close()
    #
    print("*** " + DEF.APPLICATION_TITLE + ": end")
#
#
###################################################################
#

