#
#----------------------------------------------------------------------
#   FrameState
#----------------------------------------------------------------------
import tkinter as TKI
#
#import Define as DEF
#
#----------------------------------------------------------------------
#
class CFrameProtocol(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        #
        self.rowconfigure(0, weight=1)
        self.columnconfigure(0, weight=1)
        self.lbxProtocol = TKI.Listbox(self,
                                       font = "Courier 10",
                                       activestyle = TKI.NONE)
        self.lbxProtocol["selectmode"] = "single"
        self.lbxProtocol.grid(row=0, column=0, sticky='wnse')
        #
        self.scbProtocol = TKI.Scrollbar(self, orient = TKI.VERTICAL)
        self.scbProtocol.grid(row = 0, column = 3, sticky = "NSW")
        self.lbxProtocol["yscrollcommand"] = self.scbProtocol.set
        self.scbProtocol["command"] = self.lbxProtocol.yview
        # debug for I in range(0, 50):
        # debug self.lbxProtocol.insert(TKI.END, '...')
        return
    #
    def Line(self, line):
        self.lbxProtocol.insert(TKI.END, line)
        self.lbxProtocol.itemconfig(TKI.END, {'bg':'#efffdf'})
        self.lbxProtocol.selection_clear(0, TKI.END)
        self.lbxProtocol.selection_set('end')
        self.lbxProtocol.see('end')
        return



    #
    def Clear(self):
        self.lbxProtocol.delete(0, TKI.END)
    #
    def SaveFile(self, fileentry):
        F = open(fileentry, 'w')
        if (None == F):
            return False
        for Line in self.SData:
            F.write(Line + '\r')
        F.close()
        return True
    #

    #
    #
#
#
