#
#----------------------------------------------------------------------
#   FrameState
#----------------------------------------------------------------------
import tkinter as TKI
from tkinter import filedialog as TKFD
#
import Define as DEF
#
#----------------------------------------------------------------------
#
class CFrameProtocolGlobal(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        #
        self.rowconfigure(0, weight=1)
        self.columnconfigure(0, weight=1)
        #
        self.lbxProtocol = TKI.Listbox(self,
                                       font = "Courier 10",
                                       activestyle = TKI.NONE)
        self.lbxProtocol["selectmode"] = "single"
        self.lbxProtocol.grid(row=0, column=0, sticky='wnse')
        #
        self.scbProtocol = TKI.Scrollbar(self, orient = TKI.VERTICAL)
        self.scbProtocol.grid(row = 0, column = 3, sticky = "NSW")
        self.lbxProtocol["yscrollcommand"] = self.scbProtocol.set
        self.scbProtocol["command"] = self.lbxProtocol.yview
        # debug for I in range(0, 50):
        # debug self.lbxProtocol.insert(TKI.END, '...')
        #
        self.ClearAll()
        return
    #
    def Line(self, line):
        self.lbxProtocol.insert(TKI.END, line)
        self.lbxProtocol.itemconfig(TKI.END, {'bg':'#efffdf'})
        self.lbxProtocol.selection_clear(0, TKI.END)
        self.lbxProtocol.selection_set('end')
        self.lbxProtocol.see('end')
        return
    #
    def ClearAll(self):
        self.lbxProtocol.delete(0, TKI.END)
        return
    #
    def WriteToFile(self):
        FT = (('Protocolfiles', '*.txt'),
              ('All files', '*.*'))
        FN = DEF.FILENAME_PROTOCOLGLOBAL
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.txt',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            #
            F = open(FN, 'w')
            if (None != F):
                for Line in self.lbxProtocol.get(0, TKI.END):
                    F.write(Line + '\r')
                F.close()
                return True
            return False
            #
        return False
    #
    #
#
#
