#
import time as TIM
#import numpy as NUM
#
import Define as DEF
import Helper as HLP
import Task as TSK
#
#import GCodeConverter as GCV
import GCodeSimulator as GCS
#
#---------------------------------------------------------
# Field - 3D
#---------------------------------------------------------
VX3D = []
VY3D = []
VZ3D = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 32 # 1024
Direction = True
GlobalTicks = 0
Azimuth = HLP.DegRad(30.0)
Elevation = HLP.DegRad(30.0)
#
class CGCodeExecutor():
    #
    def __init__(self, onprotocol):
        self.Protocol = onprotocol
        self.EventDisplayReady = TSK.CEvent()
        self.TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                             self.OnTaskDisplayPlotdataStart,
                                             self.OnTaskDisplayPlotdataAbort,
                                             self.OnTaskDisplayPlotdataExecute)
        self.TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                            self.OnTaskCreatePlotdataStart,
                                            self.OnTaskCreatePlotdataAbort,
                                            self.OnTaskCreatePlotdataExecute)
        self.GCodeSimulator = GCS.CGCodeSimulator(self.Protocol)
        self.GCodeList = []
        self.OnGCodeListChanged = None
        #self.GCodeConverter = GCV.CGCodeConverter(self.Protocol)
        self.FileEntry = ''
        self.EventDisplayReady = TSK.CEvent()
        self.EventDisplayReady.Set()
        self.FramePlot2D = None
        self.FramePlot3D = None
        return
    #---------------------------------------------------------
    # Property
    #---------------------------------------------------------
    def SetOnGCodeListChanged(self, callback):
        self.OnGCodeListChanged = callback
    def SetGCodeList(self, gcodelist):
        self.GCodeList = gcodelist
        if (None != self.OnGCodeListChanged):
            self.OnGCodeListChanged(0 < len(self.GCodeList))
    #---------------------------------------------------------
    # Callback - Task - Refresh
    #---------------------------------------------------------
    def OnTaskDisplayPlotdataStart(self, task):
        # debug self.Protocol('### OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
        self.EventDisplayReady.Clear()
        # debug self.Protocol('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
        return
    def OnTaskDisplayPlotdataAbort(self, task):
        # debug self.Protocol('##### OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
        # debug self.Protocol('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
        return
    #
    def OnTaskDisplayPlotdataExecute(self, task):
        # debug self.Protocol('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
        # try:
        T0 = TIM.time()
        T1 = T0
        IL = 0
        IH = max(1, len(self.GCodeSimulator.GetVX1()) - 1)
        IA = 0
        Loop = True
        while (Loop):
            if ((T1 + DEF.TIME_REFRESH) < TIM.time()):
                T1 = T1 + DEF.TIME_REFRESH
                #----------------------------------------
                # Plot2D
                #----------------------------------------
                IA = min(IH, 1 + IA)
                XL = self.GCodeSimulator.GetXL()
                XH = self.GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = self.GCodeSimulator.GetYL()
                YH = self.GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                self.FramePlot2D.SetXL(XL)
                self.FramePlot2D.SetXH(XH)
                self.FramePlot2D.SetYL(YL)
                self.FramePlot2D.SetYH(YH)
                self.FramePlot2D.Refresh(self.GCodeSimulator.GetVX0(),
                                         self.GCodeSimulator.GetVY0(),
                                         self.GCodeSimulator.GetVX1(),
                                         self.GCodeSimulator.GetVY1(),
                                         IL, IA, IH, 1)
                TIM.sleep(self.GCodeSimulator.GetTP() / IH)
                #----------------------------------------
                # Plot3D
                #----------------------------------------
                global VX3D, VY3D, VZ3D
                global Azimuth, Elevation
                VX3D = self.GCodeSimulator.GetVX0()
                VY3D = self.GCodeSimulator.GetVY0()
                VZ3D = self.GCodeSimulator.GetVZ0()
                ZL = self.GCodeSimulator.GetZL()
                ZH = self.GCodeSimulator.GetZH()
                DZT = (ZH - ZL) / 10.0
                ZL -= DZT
                ZH += DZT
                self.FramePlot3D.SetVX(VX3D)
                self.FramePlot3D.SetVY(VY3D)
                self.FramePlot3D.SetVZ(VZ3D)
                self.FramePlot3D.SetXL(XL)
                self.FramePlot3D.SetXH(XH)
                self.FramePlot3D.SetYL(YL)
                self.FramePlot3D.SetYH(YH)
                self.FramePlot3D.SetZL(ZL)
                self.FramePlot3D.SetZH(ZH)
                Elevation += HLP.DegRad(5.0)
                Azimuth += HLP.DegRad(10.0)
                self.FramePlot3D.SetElevation(Elevation)
                self.FramePlot3D.SetAzimuth(Azimuth)
                self.FramePlot3D.Refresh(self.GCodeSimulator.GetVX0(),
                                         self.GCodeSimulator.GetVY0(),
                                         self.GCodeSimulator.GetVZ0(),
                                         self.GCodeSimulator.GetVX1(),
                                         self.GCodeSimulator.GetVY1(),
                                         self.GCodeSimulator.GetVZ1(),
                                         IL, IA, IH, 1)
            else:
                TIM.sleep(0.001)
            if (self.GCodeSimulator.GetTP() <= (T1 - T0)):
                Loop = False
            #
        self.FramePlot2D.Idle()
        self.EventDisplayReady.Set()
        # debug  self.Protocol('OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
        # except:
        #     self.Protocol('Error: Executing Display')
        return False
    #---------------------------------------------------------
    # Callback - Task - Action
    #---------------------------------------------------------
    def OnTaskCreatePlotdataStart(self, task):
        return
    def OnTaskCreatePlotdataAbort(self, task):
        if (self.TaskDisplayPlotdata.IsBusy()):
            self.TaskDisplayPlotdata.Abort()
        return
    def OnTaskCreatePlotdataExecute(self, task):
        ###self.Protocol('>>> Read GCodeList from File[{0}]:'.format(self.FileEntry))
        #[GCodeList, GCodeLines] = self.GCodeConverter.ReadFromFile(self.FileEntry)
        #for IL in range(0, len(self.GCodeList)):
        #    GCode = GCodeList[IL]
        #    self.Protocol(GCode.Text())
        self.Protocol('>>> ExecuteGCodelist[{0}]: begin'.format(len(self.GCodeList)))
        for GCode in self.GCodeList:
            if task.IsBusy():
                self.GCodeSimulator.ExecuteGCode(GCode)
            if task.IsBusy():
                self.TaskDisplayPlotdata.Start()
            if task.IsBusy():
                self.EventDisplayReady.Wait()
        if task.IsBusy():
            self.Protocol('>>> ExecuteGCodelist[{0}]: end'.format(len(self.GCodeList)))
        return False
    #
    #---------------------------------------------------------
    # Handler
    #---------------------------------------------------------
    def Initialise(self, frameplot2d, frameplot3d):
        self.FramePlot2D = frameplot2d
        self.FramePlot3D = frameplot3d
    #
    def Start(self):
        #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!self.TaskCreatePlotdata.Start()
        print('Start')
        return
    #
    def Abort(self):
        #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!self.TaskCreatePlotdata.Abort()
        print('Abort')
        self.SetGCodeList([])
        return
    #
    #
#
#
