#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
import GCodeConverter as GCV
import GCodeExecutor as GEX
import GCodeHardware as GCH
#
global FrameApplication
global UartGrblController
global GCodeConverter
#
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnPositionXMoveAbsolute(positionactual, positiontarget):
    print('PX : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionXMoveRelative(positionactual, positiontarget):
    print('PX : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionYMoveAbsolute(positionactual, positiontarget):
    print('PY : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionYMoveRelative(positionactual, positiontarget):
    print('PY : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionZMoveAbsolute(positionactual, positiontarget):
    print('PZ : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionZMoveRelative(positionactual, positiontarget):
    print('PZ : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnSpindleRotateIdle():
    print('SP : RotateIdle')
    return
def OnSpindleRotateCW(speed):
    print('SP : RotateCW[{0}]'.format(speed))
    return
def OnSpindleRotateCCW(speed):
    print('SP : RotateCCW[{0}]'.format(speed))
    return
#
#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def OnProtocol(line):
    FrameApplication.Protocol(line)
#--------------------------------------------------------------------
# Callback - Main
#--------------------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        # GCodeExecutor.Abort()
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnStartExecution(None)
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnAbortExecution(None)
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
        # NC if (None != TaskExecution):
        # if (TaskExecution.IsBusy()):
        #     TaskExecution.Abort()
        UartGrblController.Close()
    except:
        pass
#



def UartOnOpen():
    FrameApplication.tbsProtocolUart.ControlsEnable()
    return
def UartOnClose():
    FrameApplication.tbsProtocolUart.ControlsDisable()
    return
def UartOnLineReceived(rxline):
    GCodeHardware.ExecuteOnLineReceived(rxline)
    FrameApplication.tbsProtocolUart.UartOnLineReceived(rxline)
    return




def FrameSetupGlobalOnReadGCodeFile(filename): # <- button
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(filename)
    FrameApplication.tbsProtocolGCode.AddGCodeList(GCodeList)
    GCodeExecutor.SetGCodeList(GCodeList)
    return
def FrameSetupGlobalOnStartExecution():
    # debug
    print('FrameSetupGlobalOnStartExecution')
    GCodeExecutor.Start()
    return
def FrameSetupGlobalOnAbortExecution():
    # debug
    print('FrameSetupGlobalOnAbortExecution')
    GCodeExecutor.Abort()
    return


def GCodeExecutorOnGCodeListChanged(ispresent):
    # debug print('GCodeExecutorOnGCodeListChanged[{0}]'.format(str(ispresent)))
    FrameApplication.tbsSetup.FrameSetupGlobal.SetGCodeListIsPresent(ispresent)
    return

def GCodeConverterOnProtocol(line):
    OnProtocol(line)
    return
def GCodeConverterOnGCodeListPresent(ispresent):
    FrameApplication.tbsSetup.FrameSetupGlobal.OnGCodeListPresent(ispresent)
    return
# Global
def FrameProtocolGlobalOnWriteToFile():
    FrameApplication.tbsProtocolGlobal.WriteToFile()
    return
def FrameProtocolGlobalOnClearAll():
    FrameApplication.tbsProtocolGlobal.ClearAll()
    return
# Uart
def FrameProtocolUartOnWriteToFile():
    FrameApplication.tbsProtocolUart.WriteToFile()
    return
def FrameProtocolUartOnClearAll():
    FrameApplication.tbsProtocolUart.ClearAll()
    return
# GCode
def FrameProtocolGCodeOnWriteToFile():
    FrameApplication.tbsProtocolGCode.WriteToFile()
    return
def FrameProtocolGCodeOnClearAll():
    FrameApplication.tbsProtocolGCode.ClearAll()
    return
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
UartGrblController = URT.CUart()
UartGrblController.SetCBOnOpen(UartOnOpen)
UartGrblController.SetCBOnClose(UartOnClose)
UartGrblController.SetCBOnLineReceived(UartOnLineReceived)
#

FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.Initialise(UartGrblController)
#
FrameApplication.SetOnProtocolGlobalWriteToFile(FrameProtocolGlobalOnWriteToFile)
FrameApplication.SetOnProtocolGlobalClearAll(FrameProtocolGlobalOnClearAll)
FrameApplication.SetOnProtocolUartWriteToFile(FrameProtocolUartOnWriteToFile)
FrameApplication.SetOnProtocolUartClearAll(FrameProtocolUartOnClearAll)
FrameApplication.SetOnProtocolGCodeWriteToFile(FrameProtocolGCodeOnWriteToFile)
FrameApplication.SetOnProtocolGCodeClearAll(FrameProtocolGCodeOnClearAll)

#
FSSG = FrameApplication.tbsSetup.FrameSetupGlobal
FSSG.SetOnReadGCodeFile(FrameSetupGlobalOnReadGCodeFile)
FSSG.SetOnStartExecution(FrameSetupGlobalOnStartExecution)
FSSG.SetOnAbortExecution(FrameSetupGlobalOnAbortExecution)
#
#GCodeReport = GCR.CGCodeReport()
#GCodePlot2D = GCP2D.CGCodePlot2D()
#
GCodeConverter = GCV.CGCodeConverter()
GCodeConverter.SetOnProtocol(GCodeConverterOnProtocol)
#####GCodeConverter.SetOnGCodeListPresent(GCodeConverterOnGCodeListPresent)
#
GCodeHardware = GCH.CGCodeHardware(UartGrblController)
#
GCodeExecutor = GEX.CGCodeExecutor(OnProtocol)
GCodeExecutor.Initialise(FrameApplication.tbsPlot2D,
                         FrameApplication.tbsPlot3D)
GCodeExecutor.SetOnGCodeListChanged(GCodeExecutorOnGCodeListChanged)
#
#
#
#GCodeList = []
#TaskExecution = TSK.CTask('TaskExecution',
#                          CBTaskGCodeExecutionOnStart,
#                          CBTaskGCodeExecutionOnAbort,
#                          CBTaskGCodeExecutionOnExecute)
#
#
PositionX = FrameApplication.frmCommands.frmPositions.frmPositionX
PositionX.SetOnMoveAbsolute(OnPositionXMoveAbsolute)
PositionX.SetOnMoveRelative(OnPositionXMoveRelative)
#
PositionY = FrameApplication.frmCommands.frmPositions.frmPositionY
PositionY.SetOnMoveAbsolute(OnPositionYMoveAbsolute)
PositionY.SetOnMoveRelative(OnPositionYMoveRelative)
#
PositionZ = FrameApplication.frmCommands.frmPositions.frmPositionZ
PositionZ.SetOnMoveAbsolute(OnPositionZMoveAbsolute)
PositionZ.SetOnMoveRelative(OnPositionZMoveRelative)
#
Spindle = FrameApplication.frmCommands.frmSpindles.frmSpindle
Spindle.SetOnRotateIdle(OnSpindleRotateIdle)
Spindle.SetOnRotateCW(OnSpindleRotateCW)
Spindle.SetOnRotateCCW(OnSpindleRotateCCW)
#
#
#----------------------------------------------
#   Main
#----------------------------------------------
if ('__main__' == __name__):
    print("*** " + DEF.APPLICATION_TITLE + ": begin")
    #
    FrameApplication.Initialise(UartGrblController)
    #
    ###    GCodeExecutor.Start('AR.gcode')
    #
    FrameApplication.Execute()
    #
    # if (UartGrblController.IsOpen()):
    #     UartGrblController.Close()
    #
    print("*** " + DEF.APPLICATION_TITLE + ": end")
#
#
###################################################################
#

