import tkinter as TKI
from tkinter import ttk as TTK
from tkinter import messagebox as TKMB
from tkinter import filedialog as TKFD
#
import Define as DEF
import Initdata as ID
import FrameGCodeHardware as FGH
import FrameSetup as FSU
import FrameProtocolGlobal as FPC
import FrameProtocolUart as FPU
import FrameProtocolGCode as FPG
import FrameStates as FSTS
import FrameCommands as FCMDS
import FramePlot2D as FP2D
import FramePlot3D as FP3D
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        #self.FrameParent.rowconfigure(0, weight=1)
        #self.FrameParent.columnconfigure(0, weight=1)
        self.FrameParent.geometry('804x626+66+66')
        #self.FrameParent.geometry('804x626+2022+33')
        self.FrameParent.title(DEF.APPLICATION_TITLE)
        #
        self.IsActive = False
        #--------------------------------------------------------
        # Menu
        #--------------------------------------------------------
        self.Menu = TKI.Menu(self.FrameParent)
        self.FrameParent.config(menu = self.Menu)
        # Menu - System
        self.MenuSystem = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "System", menu = self.MenuSystem)
        self.MenuSystem.add_command(label = "Read Initfile Default", \
                                    command = self.OnReadInitfileDefault)
        self.MenuSystem.add_command(label = "Read Initfile Dialog", \
                                    command = self.OnReadInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Write Initfile Default", \
                                    command = self.OnWriteInitfileDefault)
        self.MenuSystem.add_command(label = "Write Initfile Dialog", \
                                    command = self.OnWriteInitfileDialog)
        self.MenuSystem.add_command(label = "Exit Application", \
                                    command = self.OnExitApplication)
        # Menu - Device
        self.MenuDevice = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "Protocol", menu = self.MenuDevice)
        self.MenuDevice.add_command(label = "Global", state="disabled")
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolGlobalWriteToFile)
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolGlobalClearAll)
        self.MenuDevice.add_separator()
        self.MenuDevice.add_command(label = "Uart", state="disabled")
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolUartWriteToFile)
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolUartClearAll)
        self.MenuDevice.add_separator()
        self.MenuDevice.add_command(label = "GCode", state="disabled")
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolGCodeWriteToFile)
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolGCodeClearAll)
        # Menu - Help
        self.MenuHelp = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "Help", menu = self.MenuHelp)
        self.MenuHelp.add_command(label = "Show About", command = self.OnShowAbout)
        #--------------------------------------------------------
        # FrameState (00)
        #--------------------------------------------------------
        self.frmStates = FSTS.CFrameStates(self.FrameParent)
        self.frmStates.place(x=0, y=0, width=200, height=800)
        #--------------------------------------------------------
        # Notebook - View (01)
        #--------------------------------------------------------
        self.ntbMain = TTK.Notebook(self.FrameParent)
        self.ntbMain.place(x=203, y=0, width=800, height=600)
        #--------------------------------------------------------
        # Notebook - Tabsheet - Setup
        #--------------------------------------------------------
        self.tbsSetup = FSU.CFrameSetup(self.ntbMain)
        self.ntbMain.add(self.tbsSetup, text = "Setup")
        #-------------------------------------------------------------------------------
        # Notebook - Tabsheet - UartDataflow
        #-------------------------------------------------------------------------------
        self.tbsProtocolUart = FPU.CFrameProtocolUart(self.ntbMain)
        self.ntbMain.add(self.tbsProtocolUart, text = "ProtocolUart")
        #-------------------------------------------------------------------------------
        # Notebook - Frame - GCodeHardware
        #-------------------------------------------------------------------------------
        self.tbsGCodeHardware = FGH.CFrameGCodeHardware(self.ntbMain)
        self.ntbMain.add(self.tbsGCodeHardware, text = "GCodeHardware")
        #-------------------------------------------------------------------------------
        # Notebook - Frame - GCodeReport
        #-------------------------------------------------------------------------------
        self.tbsProtocolGCode = FPG.CFrameProtocolGCode(self.ntbMain)
        self.ntbMain.add(self.tbsProtocolGCode, text = "ProtocolGCode")

        self.a = FPG.CFrameProtocolGCode(self.ntbMain)
        self.ntbMain.add(self.a, text = "ProtocolGCode")

        self.b = FPG.CFrameProtocolGCode(self.ntbMain)
        self.ntbMain.add(self.b, text = "ProtocolGCode")

        self.c = FPG.CFrameProtocolGCode(self.ntbMain)
        self.ntbMain.add(self.c, text = "ProtocolGCode")

        #--------------------------------------------------------
        # Notebook - Tabsheet - Plot3D
        #--------------------------------------------------------
        self.tbsPlot3D = FP3D.CFramePlot3D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot3D, text='Plot3D')
        #--------------------------------------------------------
        # Notebook - Tabsheet - Plot2D
        #--------------------------------------------------------
        self.tbsPlot2D = FP2D.CFramePlot2D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot2D, text='Plot2D')
        # #--------------------------------------------------------
        # # Notebook - Tabsheet - Protocol
        # #--------------------------------------------------------
        self.tbsProtocolGlobal = FPC.CFrameProtocolGlobal(self.ntbMain)
        self.ntbMain.add(self.tbsProtocolGlobal, text='ProtocolGlobal')
        #--------------------------------------------------------
        # FrameCommand (11)
        #--------------------------------------------------------
        self.frmCommands = FCMDS.CFrameCommands(self.FrameParent)
        self.frmCommands.place(x=200, y=600, width=800, height=136)
        #--------------------------------------------------------
        self.PProtocolGlobalWriteToFile = None
        self.PProtocolGlobalClearAll = None
        self.PProtocolUartWriteToFile = None
        self.PProtocolUartClearAll = None
        self.PProtocolGCodeWriteToFile = None
        self.PProtocolGCodeClearAll = None
        #
        return
    #---------------------------------------------------------------------
    # CApplication - Property
    #---------------------------------------------------------------------
    def SetOnProtocolGlobalWriteToFile(self, onprotocolglobalwritetofile):
        self.PProtocolGlobalWriteToFile = onprotocolglobalwritetofile
    def SetOnProtocolGlobalClearAll(self, onprotocolglobalclearall):
        self.PProtocolGlobalClearAll = onprotocolglobalclearall
    def SetOnProtocolUartWriteToFile(self, onprotocoluartwritetofile):
        self.PProtocolUartWriteToFile = onprotocoluartwritetofile
    def SetOnProtocolUartClearAll(self, onprotocoluartclearall):
        self.PProtocolUartClearAll = onprotocoluartclearall
    def SetOnProtocolGCodeWriteToFile(self, onprotocolgcodewritetofile):
        self.PProtocolGCodeWriteToFile = onprotocolgcodewritetofile
    def SetOnProtocolGCodeClearAll(self, onprotocolgcodeclearall):
        self.PProtocolGCodeClearAll = onprotocolgcodeclearall
    #---------------------------------------------------------------------
    # CApplication - Initdata
    #---------------------------------------------------------------------
    def Initialise(self, uart):
        self.IsActive = True
        self.Protocol('CFrameApplication.Initialise')
        # self.Uart = uart
        # self.FrameSetup.SetLinkUart(uart)
        # self.FrameUartDataflow.SetLinkUart(uart)
        self.ReadInitdata(DEF.NAME_INITFILE)
        return
    #
    def ReadInitdata(self, filename):
        self.Protocol('CFrameApplication.ReadInitdata: begin')
        RID = ID.CReadInitdata()
        RID.Open(filename)
        X = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_X, DEF.INIT_X)
        Y = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_Y, DEF.INIT_Y)
        W = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_W, DEF.INIT_W)
        H = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_H, DEF.INIT_H)
        self.FrameParent.geometry('%dx%d+%d+%d' % (int(W), int(H), int(X), int(Y)))
        #
        STI = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX,
                                DEF.INIT_SELECTTABINDEX)
        self.ntbMain.select(int(STI))
        # #
        # self.FrameGCodeReport.ReadInitdata(RID)
        # self.FrameGCodeHardware.ReadInitdata(RID)
        # #self.FrameSetup.ReadInitdata(RID)
        # #self.FrameUartDataflow.ReadInitdata(RID)
        #
        RID.Close()
        self.Protocol('CFrameApplication.ReadInitdata: end')
        return
    #
    def WriteInitdata(self, filename):
        self.Protocol('CFrameApplication.WriteInitdata: begin')
        WID = ID.CWriteInitdata()
        WID.Open(filename)
        X = self.FrameParent.winfo_x()
        Y = self.FrameParent.winfo_y()
        W = self.FrameParent.winfo_width()
        H = self.FrameParent.winfo_height()
        WID.WriteSection(DEF.INITDATA_SECTION)
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_X, str(X))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_Y, str(Y))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_W, str(W))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_H, str(H))
        #
        STI = self.ntbMain.index('current')
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, str(STI))
        # #
        # self.FrameGCodeReport.WriteInitdata(WID)
        # self.FrameGCodeHardware.WriteInitdata(WID)
        # #self.FrameSetup.WriteInitdata(WID)
        # #self.FrameUartDataflow.WriteInitdata(WID)

        WID.Close()
        self.Protocol('CFrameApplication.WriteInitdata: end')
        return
    #---------------------------------------------------------------------
    # CApplication - Helper
    #---------------------------------------------------------------------
    def Protocol(self, line):
        #11111111111111111111111111self.tbsProtocolGlobal.Line(line)
        return
    #---------------------------------------------------------------------
    # CApplication - Callback / Event
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        self.IsActive = False
        self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #
    def OnReadInitfileDefault(self):
        self.ReadInitdata(DEF.NAME_INITFILE)
    #
    def OnReadInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FN = TKFD.askopenfilename(title = 'Read Initfile',
                                  initialdir = '../TerminalUart',
                                  filetypes = FT)
        self.ReadInitdata(FN)
    #
    def OnWriteInitfileDefault(self):
        self.WriteInitdata(DEF.NAME_INITFILE)
    #
    def OnWriteInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.ini',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.WriteInitdata(FN)
    #
    def OnProtocolGlobalWriteToFile(self):
        if (None != self.PProtocolGlobalWriteToFile):
            self.PProtocolGlobalWriteToFile()
        return
    def OnProtocolGlobalClearAll(self):
        if (None != self.PProtocolGlobalClearAll):
            self.PProtocolGlobalClearAll()
        return
    #
    def OnProtocolUartWriteToFile(self):
        if (None != self.PProtocolUartWriteToFile):
            self.PProtocolUartWriteToFile()
        return
    def OnProtocolUartClearAll(self):
        if (None != self.PProtocolUartClearAll):
            self.PProtocolUartClearAll()
        return
    #
    def OnProtocolGCodeWriteToFile(self):
        if (None != self.PProtocolGCodeWriteToFile):
            self.PProtocolGCodeWriteToFile()
        return
    def OnProtocolGCodeClearAll(self):
        if (None != self.PProtocolGCodeClearAll):
            self.PProtocolGCodeClearAll()
        return
    #
    def OnShowAbout(self):
        TKMB.showinfo("About", DEF.INFO_ABOUT)
    #
    def OnExitApplication(self):
        self.OnWMDeleteWindow()
    #---------------------------------------------------------------------
    # CApplication - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
    #
    #
#
#
