#
# ------------------------------------------------------------------
#   FrameGCodeHardware
# ------------------------------------------------------------------
#   Version: 00V01
#   Date   : 221012
#   Time   : 1508
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import ttk as TTK
#
#------------------------------------------------------------------
#   Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameGCodeHardware'
#
NAME_TXTEXT                     = 'TxText'
NAME_COUNTTXENTRIES             = 'CountTxEntries'
MASK_TXENTRY                    = 'Entry'
#
#INIT_TXTEXT                     = 'Hello World!'
#INIT_COUNTTXENTRIES             = '0'
#INIT_TXENTRY                    = ''
#
HEADER_RXCHARACTER              = ''
HEADER_RXLINE                   = 'RES>'
HEADER_TXLINE                   = 'CMD>'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameGCodeHardware(TKI.Frame):
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 610, height = 532, \
                           padx = 2, pady = 2, bg = "#F2F2F2")
        #
        self.Uart = None
        #
        self.grid_rowconfigure(1, weight = 1) # stretch to windowheight
        # self.grid_rowconfigure(1, weight = 1)
        self.grid_columnconfigure(1, weight = 999) # stretch to windowwidth
        # self.grid_columnconfigure(2, weight = 1)
        #
        #--------------------------------------------------------------
        # Control
        #--------------------------------------------------------------
        self.lbxRxData = TKI.Listbox(self,
                                     font = "Courier 10", activestyle = TKI.NONE)
        self.lbxRxData["selectmode"] = "single"
        self.lbxRxData.grid(row = 1, column = 0, columnspan = 3,
                            sticky = "WENS", padx = 2, pady = 2)
        #
        self.scbRxData = TKI.Scrollbar(self, orient = TKI.VERTICAL)
        self.scbRxData.grid(row = 1, column = 3, sticky = "NSW")
        self.lbxRxData["yscrollcommand"] = self.scbRxData.set
        self.scbRxData["command"] = self.lbxRxData.yview
        #
        self.lbxRxData.insert(TKI.END, '') # necessary to avoid index-error
        self.ControlsDisable()
        self.ControlsEnable()
        self.ClearProtocol()
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------
    # def SendCommand(self, gcode):
    #     self.AddTxLine(str(gcode))
    # def SendResult(self, result, message, gcode):
    #     self.AddRxLine(str(gcode) + ' : ' + str(result) + ' : ' + message)

    def SendCommand(self, gcode):
        self.AddTxLine(gcode.Text())
        self.lbxRxData.see('end')
    #
    def SendResult(self, result, message, gcode):
        self.AddRxLine(message)
        self.lbxRxData.see('end')
    # #
    # def SendReport(self, reporttext):
    #     self.AddRxLine(reporttext)
    #
    def ControlsEnable(self):
        try:
            self.lbxRxData.configure(state = 'normal')
            self.cbxTxData.configure(state = 'normal')
        except:
            pass
    #
    def ControlsDisable(self):
        try:
            self.lbxRxData.configure(state = 'disable')
            self.cbxTxData.configure(state = 'disable')
        except:
            pass
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    #
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        # SValue = readinitdata.ReadValueInit(INITDATA_SECTION, NAME_TXTEXT, INIT_TXTEXT)
        # if (0 == len(SValue)):
        #     SValue = INIT_TXTEXT
        # self.cbxTxData.set(SValue)
        #
        #SV = readinitdata.ReadValueInit(INITDATA_SECTION,
        #                                NAME_COUNTTXENTRIES, INIT_COUNTTXENTRIES)
        # CE = int(SV)
        # self.STxData = []
        # for IE in range(0, CE):
        #     SE = MASK_TXENTRY + str(IE)
        #     SValue = readinitdata.ReadValueInit(INITDATA_SECTION,
        #                                         SE, INIT_TXENTRY)
        #     if (SValue not in self.STxData):
        #         self.STxData.append(SValue)
        # self.cbxTxData['values'] = self.STxData
        #
        return True
        #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        # writeinitdata.WriteValue(INITDATA_SECTION, NAME_TXTEXT,
        #                          self.cbxTxData.get())
        # CE = len(self.STxData)
        # writeinitdata.WriteValue(INITDATA_SECTION, NAME_COUNTTXENTRIES, str(CE))
        # for IE in range(0, CE):
        #     SE = MASK_TXENTRY + str(IE)
        #     writeinitdata.WriteValue(INITDATA_SECTION, SE, self.STxData[IE])
        #
        return True
        #
    #---------------------------------------------------------------
    # Management -
    #--------------------------------------------------------------
    def AddRxCharacter(self, rxline):
        self.lbxRxData.insert(TKI.END, HEADER_RXCHARACTER + rxline)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#eeffcc'}) #{'bg':'#cceeaa'})
    #
    def AddRxLine(self, rxline):
        self.lbxRxData.insert(TKI.END, HEADER_RXLINE + rxline)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#eeffcc'}) #{'bg':'#cceeaa'})
    #
    def AddTxLine(self, txline):
        self.lbxRxData.insert(TKI.END, HEADER_TXLINE + txline)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#cceeff'}) # {'bg':'#ffeeaa'})
    #
    def ClearProtocol(self):
        self.lbxRxData.delete(0, TKI.END)
        self.STxData = []
    #
    def SaveProtocolfile(self, fileentry):
        F = open(fileentry, 'w')
        if (None == F):
            return False
        for Line in self.STxData:
            F.write(Line + '\r')
        F.close()
        return True
    #
    #
#
#






