#
import time as TIM
import numpy as NUM
#
import Define as DEF
import Helper as HLP
import Task as TSK
#
#---------------------------------------------------------
# Field - 3D
#---------------------------------------------------------
VX3D = []
VY3D = []
VZ3D = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 32 # 1024
Direction = True
GlobalTicks = 0
Azimuth = HLP.DegRad(30.0)
Elevation = HLP.DegRad(30.0)
#
class CGCodeExecutor():
    #
    def __init__(self):
        self.EventDisplayReady = TSK.CEvent()
        self.TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                             self.OnTaskDisplayPlotdataStart,
                                             self.OnTaskDisplayPlotdataAbort,
                                             self.OnTaskDisplayPlotdataExecute)
        self.TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                            self.OnTaskCreatePlotdataStart,
                                            self.OnTaskCreatePlotdataAbort,
                                            self.OnTaskCreatePlotdataExecute)
        self.Protocol = None
        self.GCodeSimulator = None
        self.GCodeConverter = None
        self.FileEntry = ''
        self.EventDisplayReady = TSK.CEvent()
        self.EventDisplayReady.Set()
        self.FramePlot2D = None
        self.FramePlot3D = None
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def SetProtocol(self, value):
        self.Protocol = value
    #
    def SetGCodeConverter(self, value):
        self.GCodeConverter = value
    def SetGCodeSimulator(self, value):
        self.GCodeSimulator = value
    #---------------------------------------------------------
    # Callback - Task - Refresh
    #---------------------------------------------------------
    def OnTaskDisplayPlotdataStart(self, task):
        # debug self.Protocol('### OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
        self.EventDisplayReady.Clear()
        # debug self.Protocol('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
        return
    def OnTaskDisplayPlotdataAbort(self, task):
        # debug self.Protocol('##### OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
        # debug self.Protocol('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
        return
    #
    def OnTaskDisplayPlotdataExecute(self, task):
        # debug self.Protocol('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
        global VX3D, VY3D, VZ3D
        global Azimuth, Elevation
        try:
            T0 = TIM.time()
            IL = 0
            IH = max(1, len(self.GCodeSimulator.GetVX1()) - 1)
            IA = 0
            Loop = True
            while (Loop):
                #----------------------------------------
                # Plot2D
                #----------------------------------------
                IA = min(IH, 1 + IA)
                XL = self.GCodeSimulator.GetXL()
                XH = self.GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = self.GCodeSimulator.GetYL()
                YH = self.GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                self.FramePlot2D.SetXL(XL)
                self.FramePlot2D.SetXH(XH)
                self.FramePlot2D.SetYL(YL)
                self.FramePlot2D.SetYH(YH)
                self.FramePlot2D.Plot(self.GCodeSimulator.GetVX0(),
                                      self.GCodeSimulator.GetVY0(),
                                      self.GCodeSimulator.GetVX1(),
                                      self.GCodeSimulator.GetVY1(),
                                      IL, IA, IH)
                #----------------------------------------
                # Plot3D
                #----------------------------------------
                ZL = self.GCodeSimulator.GetZL()
                ZH = self.GCodeSimulator.GetZH()
                DZT = (ZH - ZL) / 10.0
                ZL -= DZT
                ZH += DZT
                self.FramePlot3D.SetVX0(self.GCodeSimulator.GetVX0())
                self.FramePlot3D.SetVY0(self.GCodeSimulator.GetVY0())
                self.FramePlot3D.SetVZ0(self.GCodeSimulator.GetVZ0())
                self.FramePlot3D.SetVX1(self.GCodeSimulator.GetVX1())
                self.FramePlot3D.SetVY1(self.GCodeSimulator.GetVY1())
                self.FramePlot3D.SetVZ1(self.GCodeSimulator.GetVZ1())
                self.FramePlot3D.SetXL(XL)
                self.FramePlot3D.SetXH(XH)
                self.FramePlot3D.SetYL(YL)
                self.FramePlot3D.SetYH(YH)
                self.FramePlot3D.SetZL(ZL)
                self.FramePlot3D.SetZH(ZH)
                Elevation += HLP.DegRad(5.0)
                Azimuth += HLP.DegRad(5.0)
                self.FramePlot3D.SetElevation(Elevation)
                self.FramePlot3D.SetAzimuth(Azimuth)
                self.FramePlot3D.Plot(IL, IA, IH)#self.GCodeSimulator.GetVX0(),
                #                       # self.GCodeSimulator.GetVY0(),
                #                       # self.GCodeSimulator.GetVZ0(),
                #                       # self.GCodeSimulator.GetVX1(),
                #                       # self.GCodeSimulator.GetVY1(),
                #                       # self.GCodeSimulator.GetVZ1(),
                #                       # IL, IA, IH)
                #
                DT = max(0.0001, self.GCodeSimulator.GetTP() / IH / 8.0) # / 8.0 for time
                TIM.sleep(DT)
                #
                Loop = ((TIM.time() - T0) < self.GCodeSimulator.GetTP())
                Loop = Loop and task.IsBusy()
            #
            self.EventDisplayReady.Set()
            # debug  self.Protocol('OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
        except:
            self.Protocol('Error: Executing Display')
        print('SET')
        self.EventDisplayReady.Set()
        return False    #---------------------------------------------------------
    # Callback - Task - Action
    #---------------------------------------------------------
    def OnTaskCreatePlotdataStart(self, task):
        return
    def OnTaskCreatePlotdataAbort(self, task):
        self.TaskDisplayPlotdata.Abort()
        return
    def OnTaskCreatePlotdataExecute(self, task):
        print('GCodeExecutor.Read GCodeList from File[{0}]:'.format(self.FileEntry))
        [GCodeList, GCodeLines] = self.GCodeConverter.ReadFromFile(self.FileEntry)
        #print(GCodeList, GCodeLines)
        for IL in range(0, len(GCodeList)):
            GCode = GCodeList[IL]
            print(GCode.Text())
        print('GCodeExecutor.ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
        for GCode in GCodeList:
            self.GCodeSimulator.ExecuteGCode(GCode)
            self.TaskDisplayPlotdata.Start()
            self.EventDisplayReady.Wait()
            if not(task.IsBusy()):
                break
        #self.Protocol        print('GCodeExecutor.ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
        return False
    #
    #---------------------------------------------------------
    # Handler
    #---------------------------------------------------------
    def Init(self, frameplot2d, frameplot3d):
        #
        print('Init')
        self.FramePlot2D = frameplot2d
        self.FramePlot3D = frameplot3d
    #
    def Start(self, fileentry):
        self.FileEntry = fileentry
        #
        print('Start')
        self.TaskCreatePlotdata.Start()
        return
    #
    def Abort(self):
        #
        print('Abort')
        #TIM.sleep(3.0)
        self.TaskCreatePlotdata.Abort()
        return
    #
    #
#
#
