#
import time as TIM
from enum import Enum
#
import Define as DEF
import Task as TSK
#
#---------------------------------------------------------
# Field - 3D
#---------------------------------------------------------
VX3D = []
VY3D = []
VZ3D = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 32 # 1024
Direction = True
GlobalTicks = 0
Azimuth = DEF.INIT_AZIMUTH
DAzimuth = DEF.INIT_DAZIMUTH
Elevation = DEF.INIT_ELEVATION
DElevation = DEF.INIT_DELEVATION
#
class EStateExecutor(Enum):
    Init = 0
    Idle = 1
    Busy = 2
#
class CGCodeExecutor():
    #
    def __init__(self):
        self.State = EStateExecutor.Idle
        self.EventDisplayReady = TSK.CEvent()
        self.TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                             self.OnTaskDisplayPlotdataStart,
                                             self.OnTaskDisplayPlotdataAbort,
                                             self.OnTaskDisplayPlotdataExecute)
        self.TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                            self.OnTaskCreatePlotdataStart,
                                            self.OnTaskCreatePlotdataAbort,
                                            self.OnTaskCreatePlotdataExecute)
        self.Protocol = None
        self.GCodeSimulator = None
        self.GCodeConverter = None
        self.FileEntry = ''
        self.EventDisplayReady = TSK.CEvent()
        self.EventDisplayReady.Set()
        self.FramePlot2D = None
        self.FramePlot3D = None
        self.GCodeList = []
        self.OnStateChanged = None
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def SetState(self, state):
        self.State = state
        if (None != self.OnStateChanged):
            self.OnStateChanged(self.State)
    #
    def SetOnStateChanged(self, value):
        self.OnStateChanged = value
    #
    def SetProtocol(self, value):
        self.Protocol = value
    #
    def SetGCodeConverter(self, value):
        self.GCodeConverter = value
    def SetGCodeSimulator(self, value):
        self.GCodeSimulator = value
    #---------------------------------------------------------
    # Callback - Task - Refresh
    #---------------------------------------------------------
    def OnTaskDisplayPlotdataStart(self, task):
        # debug self.Protocol('### OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
        self.EventDisplayReady.Clear()
        return
    def OnTaskDisplayPlotdataAbort(self, task):
        return
    #
    def OnTaskDisplayPlotdataExecute(self, task):
        global VX3D, VY3D, VZ3D
        global Azimuth, DAzimuth, Elevation, DElevation
        try:
            T0 = TIM.time()
            IL = 0
            IH = max(1, len(self.GCodeSimulator.GetVX1()) - 1)
            IA = 0
            Loop = True
            while (Loop):
                #----------------------------------------
                # Plot2D
                #----------------------------------------
                IA = min(IH, 1 + IA)
                XL = self.GCodeSimulator.GetXL()
                XH = self.GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = self.GCodeSimulator.GetYL()
                YH = self.GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                self.FramePlot2D.SetXL(XL)
                self.FramePlot2D.SetXH(XH)
                self.FramePlot2D.SetYL(YL)
                self.FramePlot2D.SetYH(YH)
                self.FramePlot2D.Plot(self.GCodeSimulator.GetVX0(),
                                      self.GCodeSimulator.GetVY0(),
                                      self.GCodeSimulator.GetVX1(),
                                      self.GCodeSimulator.GetVY1(),
                                      IL, IA, IH)
                #----------------------------------------
                # Plot3D
                #----------------------------------------
                ZL = self.GCodeSimulator.GetZL()
                ZH = self.GCodeSimulator.GetZH()
                DZT = (ZH - ZL) / 10.0
                ZL -= DZT
                ZH += DZT
                self.FramePlot3D.SetVX0(self.GCodeSimulator.GetVX0())
                self.FramePlot3D.SetVY0(self.GCodeSimulator.GetVY0())
                self.FramePlot3D.SetVZ0(self.GCodeSimulator.GetVZ0())
                self.FramePlot3D.SetVX1(self.GCodeSimulator.GetVX1())
                self.FramePlot3D.SetVY1(self.GCodeSimulator.GetVY1())
                self.FramePlot3D.SetVZ1(self.GCodeSimulator.GetVZ1())
                self.FramePlot3D.SetXL(XL)
                self.FramePlot3D.SetXH(XH)
                self.FramePlot3D.SetYL(YL)
                self.FramePlot3D.SetYH(YH)
                self.FramePlot3D.SetZL(ZL)
                self.FramePlot3D.SetZH(ZH)
                #
                if (Azimuth < 10.0):
                    DAzimuth = DEF.INIT_DAZIMUTH
                    Azimuth = 10.0
                elif (80.0 < Azimuth):
                    DAzimuth = -DEF.INIT_DAZIMUTH
                    Azimuth = 80.0
                else:
                    Azimuth += DAzimuth
                #
                if (Elevation < 10.0):
                    DElevation = DEF.INIT_DELEVATION
                    Elevation = 10.0
                elif (80.0 < Elevation):
                    DElevation = -DEF.INIT_DELEVATION
                    Elevation = 80.0
                else:
                    Elevation += DElevation
                #
                self.FramePlot3D.SetElevation(Elevation)
                self.FramePlot3D.SetAzimuth(Azimuth)
                self.FramePlot3D.Plot(IL, IA, IH)
                #
                DT = max(0.0001, self.GCodeSimulator.GetTP() / IH / 8.0) # / 8.0 for time
                TIM.sleep(DT)
                #
                Loop = ((TIM.time() - T0) < self.GCodeSimulator.GetTP())
                Loop = Loop and task.IsBusy()
            #
            self.EventDisplayReady.Set()
        except:
            self.Protocol('Error: Executing Display')
        self.EventDisplayReady.Set()
        return False    #---------------------------------------------------------
    # Callback - Task - Action
    #---------------------------------------------------------
    def OnTaskCreatePlotdataStart(self, task):
        return
    def OnTaskCreatePlotdataAbort(self, task):
        self.TaskDisplayPlotdata.Abort()
        return
    def OnTaskCreatePlotdataExecute(self, task):
        self.Protocol('GCodeExecutor.ExecuteGCodelist[{0}]: begin'.format(len(self.GCodeList)))
        Loop = True
        while (Loop):
            GCode = self.GCodeList.pop(0)
            print(GCode)
            self.GCodeSimulator.ExecuteGCode(GCode)
            self.TaskDisplayPlotdata.Start()
            self.EventDisplayReady.Wait()
            Loop = (0 < len(self.GCodeList)) and task.IsBusy()
        self.SetState(EStateExecutor.Idle)
        self.Protocol('GCodeExecutor.ExecuteGCodelist[{0}]: end'.format(len(self.GCodeList)))
        return False
    #
    #---------------------------------------------------------
    # Handler
    #---------------------------------------------------------
    def Init(self, frameplot2d, frameplot3d):
        self.SetState(EStateExecutor.Init)
        self.FramePlot2D = frameplot2d
        self.FramePlot3D = frameplot3d
    #
    def Start(self, gcodelist):
        if (None != gcodelist):
            if (0 < len(gcodelist)):
                self.GCodeList = gcodelist
                self.Protocol('GCodeExecutor.Start({0})'.format(len(self.GCodeList)))
                self.SetState(EStateExecutor.Busy)
                self.TaskCreatePlotdata.Start()
                return True
        self.Protocol('GCodeExecutor.Start - Error')
        self.SetState(EStateExecutor.Idle)
        return False
    #
    def Abort(self):
        self.Protocol('GCodeExecutor.Abort')
        self.TaskCreatePlotdata.Abort()
        self.SetState(EStateExecutor.Idle)
        return
    #
    #
#
#
