#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
import GCodeConverter as GCV
import GCodeSimulator as GCS
import GCodeExecutor as GEX
import GCodeHardware as GCH
#
global FrameApplication
global UartGrblController
global GCodeConverter
#
#------------------------------------------------------------
# Callback - Uart
#------------------------------------------------------------
def UartOnOpen():
    FrameApplication.tbsProtocolUart.ControlsEnable()
    return
def UartOnClose():
    FrameApplication.tbsProtocolUart.ControlsDisable()
    return
def UartOnLineReceived(rxline):
    GCodeHardware.ExecuteOnLineReceived(rxline)
    FrameApplication.tbsProtocolUart.UartOnLineReceived(rxline)
    return
#------------------------------------------------------------
# Callback - FrameSetupGlobal
#------------------------------------------------------------
def FrameSetupGlobalLoadExecuteGCodeFile(filename):
    print('FrameSetupGlobalLoadExecuteGCodeFile')
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(filename)
    GCodeExecutor.Start(GCodeList)
    return
def FrameSetupGlobalAbortExecutionGCodeList():
    print('FrameSetupGlobalAbortExecution')
    GCodeExecutor.Abort()
    return
#------------------------------------------------------------
# Callback - GCodeConverter
#------------------------------------------------------------
#------------------------------------------------------------
# Callback - GCodeExecutor
#------------------------------------------------------------
def GCodeExecutorOnStateChanged(state):
    FSSG = FrameApplication.tbsSetup.FrameSetupGlobal
    if (GEX.EStateExecutor.Init == state):
        print(state)
        FSSG.SetTextLoadExecute()
    elif (GEX.EStateExecutor.Idle == state):
        print(state)
        FSSG.SetTextLoadExecute()
    elif (GEX.EStateExecutor.Busy == state):
        print(state)
        FSSG.SetTextAbortExecution()
    return
#------------------------------------------------------------
# Callback - Protocol
#------------------------------------------------------------
def FrameProtocolGlobalOnWriteToFile():
    FrameApplication.tbsProtocolGlobal.WriteToFile()
    return
def FrameProtocolGlobalOnClearAll():
    FrameApplication.tbsProtocolGlobal.ClearAll()
    return
# Uart
def FrameProtocolUartOnWriteToFile():
    FrameApplication.tbsProtocolUart.WriteToFile()
    return
def FrameProtocolUartOnClearAll():
    FrameApplication.tbsProtocolUart.ClearAll()
    return
# GCode
def FrameProtocolGCodeOnWriteToFile():
    FrameApplication.tbsProtocolGCode.WriteToFile()
    return
def FrameProtocolGCodeOnClearAll():
    FrameApplication.tbsProtocolGCode.ClearAll()
    return
#---------------------------------------------------------
# Callback - Command
#---------------------------------------------------------
def OnPositionXMoveAbsolute(positionactual, positiontarget):
    print('PX : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionXMoveRelative(positionactual, positiontarget):
    print('PX : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionYMoveAbsolute(positionactual, positiontarget):
    print('PY : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionYMoveRelative(positionactual, positiontarget):
    print('PY : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionZMoveAbsolute(positionactual, positiontarget):
    print('PZ : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionZMoveRelative(positionactual, positiontarget):
    print('PZ : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnSpindleRotateIdle():
    print('SP : RotateIdle')
    return
def OnSpindleRotateCW(speed):
    print('SP : RotateCW[{0}]'.format(speed))
    return
def OnSpindleRotateCCW(speed):
    print('SP : RotateCCW[{0}]'.format(speed))
    return
#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def ProtocolGlobal(line):
    FrameApplication.ProtocolGlobal(line)
    return
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        GCodeExecutor.Abort()
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnStartExecution(None)
        # NC WindowApplication.FrameSetup.FrameSetupGlobal.SetOnAbortExecution(None)
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
        UartGrblController.Close()
    except:
        pass
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
UartGrblController = URT.CUart()
UartGrblController.SetCBOnOpen(UartOnOpen)
UartGrblController.SetCBOnClose(UartOnClose)
UartGrblController.SetCBOnLineReceived(UartOnLineReceived)
#
FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.SetOnProtocolGlobalWriteToFile(FrameProtocolGlobalOnWriteToFile)
FrameApplication.SetOnProtocolGlobalClearAll(FrameProtocolGlobalOnClearAll)
FrameApplication.SetOnProtocolUartWriteToFile(FrameProtocolUartOnWriteToFile)
FrameApplication.SetOnProtocolUartClearAll(FrameProtocolUartOnClearAll)
FrameApplication.tbsSetup.FrameSetupUart.SetLinkUart(UartGrblController)
#
PositionX = FrameApplication.frmCommands.frmPositions.frmPositionX
PositionX.SetOnMoveAbsolute(OnPositionXMoveAbsolute)
PositionX.SetOnMoveRelative(OnPositionXMoveRelative)
#
PositionY = FrameApplication.frmCommands.frmPositions.frmPositionY
PositionY.SetOnMoveAbsolute(OnPositionYMoveAbsolute)
PositionY.SetOnMoveRelative(OnPositionYMoveRelative)
#
PositionZ = FrameApplication.frmCommands.frmPositions.frmPositionZ
PositionZ.SetOnMoveAbsolute(OnPositionZMoveAbsolute)
PositionZ.SetOnMoveRelative(OnPositionZMoveRelative)
#
Spindle = FrameApplication.frmCommands.frmSpindles.frmSpindle
Spindle.SetOnRotateIdle(OnSpindleRotateIdle)
Spindle.SetOnRotateCW(OnSpindleRotateCW)
Spindle.SetOnRotateCCW(OnSpindleRotateCCW)
#
FSSG = FrameApplication.tbsSetup.FrameSetupGlobal
FSSG.SetLoadExecuteGCodeFile(FrameSetupGlobalLoadExecuteGCodeFile)
FSSG.SetAbortExecutionGCodeList(FrameSetupGlobalAbortExecutionGCodeList)
#
GCodeHardware = GCH.CGCodeHardware()
GCodeHardware.SetLinkUart(UartGrblController)
#
GCodeConverter = GCV.CGCodeConverter()
GCodeConverter.SetProtocol(ProtocolGlobal)
#
GCodeSimulator = GCS.CGCodeSimulator()
GCodeSimulator.SetProtocol(ProtocolGlobal)
#
GCodeExecutor = GEX.CGCodeExecutor()
GCodeExecutor.SetOnStateChanged(GCodeExecutorOnStateChanged)
GCodeExecutor.SetProtocol(ProtocolGlobal)
GCodeExecutor.SetGCodeConverter(GCodeConverter)
GCodeExecutor.SetGCodeSimulator(GCodeSimulator)
GCodeExecutor.Init(FrameApplication.tbsPlot2D,
                   FrameApplication.tbsPlot3D)
#
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    ProtocolGlobal('*** GCodeInterpreter: begin')
    #
    FrameApplication.Initialise()
    #
    ######################### GCodeExecutor.Start('AR.gcode')
    ######################### GCodeExecutor.Start('ARoriginal.gcode')
    #
    FrameApplication.Execute()
    #
    ProtocolGlobal('*** GCodeInterpreter: end')
#
#
###################################################################
#

