#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg import (FigureCanvasTkAgg)#, NavigationToolbar2Tk)
import tkinter as TKI
#
import Define as DEF
#
class CFramePlot3D(TKI.Frame):
    #
    def __init__(self, parent):
        super().__init__(parent)
        self.Parent = parent
        self.Parent.rowconfigure(0, weight=1)
        self.Parent.columnconfigure(0, weight=1)
        self.Figure = PLT.figure(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                          DEF.DOTS_Y / DEF.DOTSPERINCH),
                                 dpi=DEF.DOTSPERINCH)
        self.Axis = PLT.axes(projection='3d')
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self)# .Parent)
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='nswe')
        #
        self.XL = DEF.LIMIT_X_LOW
        self.XH = DEF.LIMIT_X_HIGH
        self.YL = DEF.LIMIT_Y_LOW
        self.YH = DEF.LIMIT_Y_HIGH
        self.ZL = DEF.LIMIT_Z_LOW
        self.ZH = DEF.LIMIT_Z_HIGH
        #
        self.VX0 = []
        self.VY0 = []
        self.VZ0 = []
        self.VX1 = []
        self.VY1 = []
        self.VZ1 = []
        #
        self.LineColor = 'r'
        self.LineWidth = 1.0
        self.LineStyle = 'solid'
        self.LineMarker = '.'
        #
        self.Azimuth = DEF.INIT_AZIMUTH     # [deg]
        self.Elevation = DEF.INIT_ELEVATION # [deg]
        #
        self.Rescale()
        #
        return
    #
    def SetVX0(self, vx0):
        self.VX0 = vx0
    def SetVY0(self, vy0):
        self.VY0 = vy0
    def SetVZ0(self, vz0):
        self.VZ0 = vz0
    def SetVX1(self, vx1):
        self.VX1 = vx1
    def SetVY1(self, vy1):
        self.VY1 = vy1
    def SetVZ1(self, vz1):
        self.VZ1 = vz1
    #
    def SetXL(self, xl):
        self.XL = xl
    def SetXH(self, xh):
        self.XH = xh
    def SetYL(self, yl):
        self.YL = yl
    def SetYH(self, yh):
        self.YH = yh
    def SetZL(self, zl):
        self.ZL = zl
    def SetZH(self, zh):
        self.ZH = zh
    def SetLineColor(self, value):
        self.LineColor = value
    def SetLineWidth(self, value):
        self.LineWidth = value
    def SetLineStyle(self, value):
        self.LineStyle = value
    def SetLineMarker(self, value):
        self.LineMarker = value
    def SetElevation(self, value):
        self.Elevation = value
    def SetAzimuth(self, value):
        self.Azimuth = value
    #
    def Rescale(self):
        self.Axis.cla() # !!! necessary !!!
        self.Axis.grid("both")
        self.Axis.axis('auto')
        self.Axis.set_aspect('auto', 'box')
        self.Axis.view_init(elev=self.Elevation, azim=self.Azimuth)
        if (self.XL == self.XH):
            self.XH = 0.1 + self.XL
        if (self.YL == self.YH):
            self.YH = 0.1 + self.YL
        if (self.ZL == self.ZH):
            self.ZH = 0.1 + self.ZL
        self.Axis.set_xlim(self.XL, self.XH)
        self.Axis.set_ylim(self.YL, self.YH)
        self.Axis.set_zlim(self.ZL, self.ZH)
        self.Axis.set_xlabel("x")
        self.Axis.set_ylabel("y")
        self.Axis.set_zlabel("z")
        return
    #
    def Plot(self, il, ia, ih):
        self.Rescale()
        self.IL = il
        self.IA = ia
        self.IH = ih
        if (0 < len(self.VX1)):
            self.Axis.plot(self.VX1[self.IA:self.IH],
                            self.VY1[self.IA:self.IH],
                            self.VZ1[self.IA:self.IH],
                            color='#ff888855',
                            linewidth=3.0,
                            linestyle='solid')
            self.Axis.plot(self.VX1[self.IL:self.IA],
                            self.VY1[self.IL:self.IA],
                            self.VZ1[self.IL:self.IA],
                            color='#ff8888',
                            linewidth=4.0,
                            linestyle='solid')
        if (0 < len(self.VX0)):
            self.Axis.plot(self.VX0, self.VY0, self.VZ0,
                           color='blue',
                           linewidth=3.0,
                           linestyle='solid')
        self.Canvas.flush_events()
        self.Canvas.draw()
        return
    #
    #
#
#




