#
import re as RE
import time as TIM
from enum import Enum
#
import Define as DEF
import Helper as HLP
import Task as TSK
import Command as CMD
#
class EStateHardware(Enum):
    Idle = 0
    Transmit = 1
    Receive = 2
#
class CGCodeHardware():
    #
    def __init__(self):
        self.Uart = None
        self.RxLines = []
        self.State = EStateHardware.Idle
        self.OnStateChanged = None
        self.OnError = None
        self.GCode = None
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    def SetLinkUart(self, uart):
        self.Uart = uart
    #
    def SetState(self, state):
        self.State = state
        # debug print(state)
        if (None != self.OnStateChanged):
            self.OnStateChanged(self.State)
    #
    def SetOnStateChanged(self, value):
        self.OnStateChanged = value
    def SetOnError(self, value):
        self.OnError = value
    #
    def IsBusy(self):
        return (EStateHardware.Idle != self.State)
    #
    def ExecuteGCode(self, gcode):
        self.State = EStateHardware.Transmit
        ResultText = ''
        if ('<class \'Command.CCommand\'>' == str(type(gcode))):
            # print('GCodeHardware : Ignore CComment[' + gcode.Comment + ']')
            # no transmit to Uart
            ResultText = 'Not transmitted : [' + gcode.Comment + ']'
            self.State = EStateHardware.Idle
            return [True, ResultText]
            #
        elif ('<class \'Command.CGCommand\'>' == str(type(gcode))):
            GCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                GCodeLine += ' ' + str(Parameter.Text())
            # debug print('GCode[{0}]'.format(GCodeLine))
            self.Uart.WriteLine(GCodeLine)
            return [True, GCodeLine]
        elif ('<class \'Command.CMCommand\'>' == str(type(gcode))):
            MCodeLine = gcode.Code
            for Parameter in gcode.Parameterlist:
                MCodeLine += ' ' + str(Parameter.Text())
            # debug print('MCode[{0}]'.format(MCodeLine))
            self.Uart.WriteLine(MCodeLine)
            return [True, MCodeLine]
        else:
            self.State = EStateHardware.Idle
            return [False, 'Invalid GCode']
    #
    #--------------------------------------------------------------------
    #   Callback - Uart
    #--------------------------------------------------------------------
    def ExecuteOnLineReceived(self, rxline):
        #debug print('>>>' + rxline + '<<<')
        if ('ok' == rxline):
            if (EStateHardware.Idle != self.State):
                if (EStateHardware.Transmit == self.State):
                    self.SetState(EStateHardware.Receive)
                elif (EStateHardware.Receive == self.State):
                    self.SetState(EStateHardware.Idle)
                # !!!!!!!!!!!!!!!!!!! NC self.RxLines.append(rxline)
        elif ('Grbl' in rxline):
            # debug
            print('GCodeHardware.ExecuteOnLineReceived.RxComment{' + rxline + '}')
            pass
        else: # ????????? HLP.Error('Error: ')
            Tokens = RE.split(r':+', rxline)
            if (2 <= len(Tokens)):
                print('Error: {0}'.format(Tokens[1]))
            else:
                print('Error: Invalid Tokens<{0}>'.format(Tokens))
            # abort:
            if (None != self.OnError):
                self.OnError(Tokens)
    #
    def Abort(self):
        self.SetState(EStateHardware.Idle)
        return
    #
#
#
