#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import tkinter as TKI
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
import Define as DEF
#
#----------------------------------------------------------------------
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        self.FrameParent.rowconfigure(0, weight=1)
        self.FrameParent.columnconfigure(0, weight=1)
        #
        self.Figure, self.Axes = PLT.subplots(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                              DEF.DOTS_Y / DEF.DOTSPERINCH),
                                              dpi=DEF.DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self)#.FrameParent) #(!!!)
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='nswe')
        #
        self.VX = []
        self.VY = []
        self.XL = 0.0
        self.XH = 100.0
        self.YL = 0.0
        self.YH = 100.0
        self.Title = 'Plot2D'
        self.XLabel = 'X [mm]'
        self.YLabel = 'Y [mm]'
        self.LineColor = '#ccccff'
        self.LineStyle = 'solid'
        self.LineWidth = 1.8
        self.LineMarker = '.'
        #
        self.Rescale()
        return
    #
    def SetVX(self, data):
        self.VX = data
    def SetVY(self, data):
        self.VY = data
    #
    def SetXL(self, data):
        self.XL = data
    def SetXH(self, data):
        self.XH = data
    def SetYL(self, data):
        self.YL = data
    def SetYH(self, data):
        self.YH = data
    #
    def SetTitle(self, data):
        self.Title = data
    def SetXLabel(self, data):
        self.XLabel = data
    def SetYLabel(self, data):
        self.YLabel = data
    def SetLineColor(self, data):
        self.LineColor = data
    def SetLineStyle(self, data):
        self.LineStyle = data
    def SetLineWidth(self, data):
        self.LineWidth = data
    def SetLineMarker(self, data):
        self.LineMarker = data
    #
    def Rescale(self):
        if (self.XL == self.XH):
            return
        if (self.YL == self.YH):
            return
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        PLT.title(self.Title)
        PLT.xlabel(self.XLabel)
        PLT.ylabel(self.YLabel)
        PLT.xlim([self.XL, self.XH])
        PLT.ylim([self.YL, self.YH])
        return
    #
    def Plot(self, vx0, vy0, vx1, vy1, il, ia, ih):
        self.IL = il
        self.IA = ia
        self.IH = ih
        self.VX0 = vx0#.copy()
        self.VY0 = vy0#.copy()
        self.VX1 = vx1#.copy()
        self.VY1 = vy1#.copy()
        try:
            if (0 < len(self.VX0)):
                self.Rescale()
                self.Axes.plot(self.VX1[self.IA - 1:self.IH],
                               self.VY1[self.IA - 1:self.IH],
                                color='#ff000030',
                                linestyle=self.LineStyle,
                                linewidth=3)
                self.Axes.plot(self.VX1[self.IL:self.IA],
                               self.VY1[self.IL:self.IA],
                                color='#ff0000',
                                linestyle=self.LineStyle,
                                linewidth=3)
                self.Axes.plot(self.VX0, self.VY0,
                                color='#0000ff',
                                linestyle=self.LineStyle,
                                linewidth=3)
                self.Canvas.draw()
            self.FrameParent.after(self.TimePeriod, self.RefreshPeriodic)
        except:
            pass
        return
    #
    #
#
#
