#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
APPLICATION_TITLE       = "GCodeInterpreter"
APPLICATION_VERSION     = "03V00"
APPLICATION_DATE        = "221113"
APPLICATION_TIME        = "1308"
APPLICATION_AUTHOR      = "OMDevelop"
#
APPLICATION_ABSTRACT_00 = "GCode Analysing, Debugging"
APPLICATION_ABSTRACT_01 = "GCode Software Executing"
APPLICATION_ABSTRACT_02 = "GCode Hardware Executing"
#
INFO_ABOUT = APPLICATION_TITLE + "\r\n\r\n" + \
             "Version: " + APPLICATION_VERSION + "\r\n" + \
             "Date: " + APPLICATION_DATE + "\r\n" + \
             "Time: " + APPLICATION_TIME + "\r\n" + \
             "Author: " + APPLICATION_AUTHOR + "\r\n" + \
             "\r\n" + \
             "Abstract:\r\n" + \
             "- " + APPLICATION_ABSTRACT_00 + "\r\n" + \
             "- " + APPLICATION_ABSTRACT_01 + "\r\n" + \
             "- " + APPLICATION_ABSTRACT_02 + ""
#
NAME_INITFILE = APPLICATION_TITLE + ".ini"
INITDATA_SECTION = "WindowMain"
NAME_X = "X"
NAME_Y = "Y"
NAME_W = "W"
NAME_H = "H"
NAME_SELECTTABINDEX = "SelectTabIndex"
#
INIT_X = "10"
INIT_Y = "10"
INIT_W = "690"
INIT_H = "546"
INIT_SELECTTABINDEX = "0"
#--------------------------------------
FRAMEINDEX_SETUP         = 0
FRAMEINDEX_UARTDATAFLOW  = 1
FRAMEINDEX_REPORT        = 2
FRAMEINDEX_PLOT2D        = 3
FRAMEINDEX_HARDWARE      = 4
#
DOTS_X      = 600
DOTS_Y      = 600
DOTSPERINCH = 100
#
LIMIT_X_LOW           =  +0.0
LIMIT_X_HIGH          = +10.0
LIMIT_Y_LOW           =  +0.0
LIMIT_Y_HIGH          = +10.0
LIMIT_Z_LOW           =  -5.0
LIMIT_Z_HIGH          =  +5.0
##
PAD_X = 2
PAD_Y = 2
FONTSIZE_LISTBOX = 11
COLOR_BACK = "#F8FEEE"
#
#
TIME_REFRESH            = 0.10 # [s] -> GCodeSimulator!
#
INIT_AZIMUTH            = +30.00 # [deg]
INIT_DAZIMUTH           =  +0.50 # [deg]
INIT_ELEVATION          = +30.00 # [deg]
INIT_DELEVATION         =  +0.25 # [deg]
#
FEED_HIGH               = float(100.0) # [mm/s] - FeedHigh (G0)
FEED_LOW                = float(10.0)  # [mm/s] - FeedLow  (G1,G2,G3...)
#
#
##############################################
#
#----------------------------------------------
#   F-Code
#----------------------------------------------
CODE_F      = 'F'       # Set Feedrate [mm/s]
#----------------------------------------------
#   G-Code
#----------------------------------------------
CODE_G      = 'G'
#
CODE_G0     = 'G0'      # Rapid Positioning at Feedrate : G0 X50 Y50 Z0
CODE_G00    = 'G0'      # G0
CODE_G1     = 'G1'      # Linear Movement at Feedrate : G1 X100 Y100 Z0 F100
CODE_G01    = 'G1'      # G1
CODE_G2     = 'G2'      # Cut Clockwise Arc : G2 X8Y5 I8 J5 F100
CODE_G02    = 'G2'      # G2
CODE_G3     = 'G3'      # Cut AntiClockwise Arc
CODE_G03    = 'G3'      # G3
CODE_G4     = 'G4'      # Pause [seconds]
CODE_G04    = 'G4'      # G4
#
CODE_G17    = 'G17'     #
CODE_G18    = 'G18'
CODE_G19    = 'G19'
CODE_G20    = 'G20'     # Select Imperial Units [inch]
CODE_G21    = 'G21'     # Select Metric Units [meter]
CODE_G28    = 'G28'     # Goto Predefined Position
CODE_G28p2  = 'G28.2'   # Run Homing Cycle
#
CODE_G38p2  = 'G38.2'   # Probe moves to Workpart with distanceout : G38.2 Z-65 F100
CODE_G38p3  = 'G38.3'   # Probe moves to Workpart without check : G38.3 Z-65 F100
CODE_G38p4  = 'G38.4'   # Probe moves from Workpart with distanceout : G38.4 Z-65 F100
CODE_G38p5  = 'G38.5'   # Probe moves from Workpart without check : G38.5 Z-65 F100
#
CODE_G53    = 'G53'     # Motion in MachineCoordinates (only G0/G1) : G53 G0 X50 Y50 Z0
CODE_G54    = 'G54'     # Select Coordinate System 1 : ???
CODE_G55    = 'G54'     # Select Coordinate System 2 : ???
CODE_G56    = 'G54'     # Select Coordinate System 3 : ???
CODE_G57    = 'G54'     # Select Coordinate System 4 : ???
CODE_G58    = 'G54'     # Select Coordinate System 5 : ???
CODE_G59    = 'G54'     # Select Coordinate System 6 : ???
#
CODE_G80    = 'G80'     # Cancel Motion Modes : ???
#
CODE_G90    = 'G90'     # Moving in Absolute (Machine)Coordinates : G90 G0 X50
CODE_G91    = 'G91'     # Moving in Relative Coordinates : G91 G0 X50
CODE_G92    = 'G92'     # Defines WorkCoordinates at X/Y/Z
CODE_G92p1  = 'G92.1'   # Resets WorkCoordinates to MachineCoordinates
#
CODE_G94    = 'G94'     # Feed per Minute Mode [mm/s] -> [mm/min]
#
#-----------------------------------------------------------------------------------------
#   M-Code
#-----------------------------------------------------------------------------------------
CODE_M      = 'M'
#
CODE_M0     = 'M0'      # Program End : M0
CODE_M2     = 'M1'      # Sleep / Stop : M2
CODE_M3     = 'M3'      # Switch Spindle On (S:Speed[rot/s]): M3 S12000
CODE_M5     = 'M5'      # Switch Spindle Off : M5
CODE_M6     = 'M6'      # Replace with Tool, display Message: M6 T42 (T42-message)
CODE_M8     = 'M8'      # Switch Coolant On : M8
CODE_M9     = 'M9'      # Switch Coolant Off : M9
#
CODE_M30    = 'M30'     # Program Pause and End : M30
#
#
#----------------------------------------------
#   Parameter-Code
#----------------------------------------------
CODE_NULL    = ''
CODE_COMMENT = ';'
CODE_X       = 'X'
CODE_Y       = 'Y'
CODE_Z       = 'Z'
CODE_H       = 'H'
CODE_I       = 'I'
CODE_J       = 'J'
CODE_K       = 'K'
CODE_L       = 'L'
CODE_N       = 'N'
CODE_P       = 'P'
CODE_R       = 'R'
CODE_S       = 'S'
CODE_T       = 'T'
CODE_F       = 'F'
#
#
