import tkinter as TKI
from PIL import Image, ImageTk
from enum import Enum as ENM
#
class EStateButton(ENM):
    sbIdle = 0
    sbBusy = 1
#
class CFrameCoolant(TKI.Frame):
    def __init__(self, frameparent,
                 width, height, sizex, sizey):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        #
        self.HeaderIdle = 'Coolant: OFF'
        self.CommandIdle = 'Switch ON'
        self.HeaderBusy = 'Coolant: ON'
        self.CommandBusy = 'Switch OFF'
        #
        self.SX = width
        self.SY = height
        self.DY = 24
        #
        self.lblHeader = TKI.Label(self, text=self.HeaderIdle)
        self.lblHeader.place(x=0, y=0, width=self.SX,
                             height=self.DY, anchor='nw')
        #
        self.btnCommand = TKI.Button(self, text=self.CommandIdle,
                                     command=self.OnButtonClick)
        self.btnCommand.place(x=0, y=self.SY, width=self.SX,
                              height=self.DY, anchor='sw')
        #
        IMGIdle = Image.open("ressource/coolantidle.png").resize((sizex, sizey), Image.NEAREST)
        self.imgIdle = ImageTk.PhotoImage(IMGIdle)
        IMGBusy = Image.open("ressource/coolantbusy.png").resize((sizex, sizey), Image.NEAREST)
        self.imgBusy = ImageTk.PhotoImage(IMGBusy)
        #
        self.lblImage = TKI.Label(self)
        self.lblImage.place(x=0, y=self.DY, width=self.SX, height=self.SY-2*self.DY)
        #
        self.SetState(EStateButton.sbIdle)
        return
    #
    def SetState(self, state):
        self.State = state
        if (EStateButton.sbBusy == state):
            self.lblImage['image'] = self.imgBusy
            self.lblHeader['text'] = self.HeaderBusy
            self.btnCommand['text'] = self.CommandBusy
            return
        self.lblImage['image'] = self.imgIdle
        self.lblHeader['text'] = self.HeaderIdle
        self.btnCommand['text'] = self.CommandIdle
        return

    #
    def OnButtonClick(self):
        if (EStateButton.sbBusy == self.State):
            self.SetState(EStateButton.sbIdle)
        else:
            self.SetState(EStateButton.sbBusy)
        return
    #
    #
#
#

