#
# ------------------------------------------------------------------
#   FrameGCodeReport
# ------------------------------------------------------------------
#   Version: 00V02
#   Date   : 221012
#   Time   : 1115
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import filedialog as TKFD
#
import Define as DEF
#
#------------------------------------------------------------------
#   Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameProtocolGCode'
#
NAME_TXTEXT                     = 'TxText'
NAME_COUNTTXENTRIES             = 'CountTxEntries'
MASK_TXENTRY                    = 'Entry'
#
INIT_TXTEXT                     = '-'
INIT_COUNTTXENTRIES             = '0'
INIT_TXENTRY                    = ''
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameProtocolGCode(TKI.Frame):
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 610, height = 532, \
                           padx = 2, pady = 2, bg = "#F2F2F2")
        #
        self.Uart = None
        #
        self.grid_rowconfigure(0, weight = 1)
        self.grid_columnconfigure(0, weight = 1)
        #
        #--------------------------------------------------------------
        # Control
        #--------------------------------------------------------------
        self.lbxProtocol = TKI.Listbox(self,
                                       font = "Courier 10",
                                       activestyle = TKI.NONE)
        self.lbxProtocol["selectmode"] = "single"
        self.lbxProtocol.grid(row=0, column=0, sticky='wnse')
        #
        self.scbProtocol = TKI.Scrollbar(self, orient = TKI.VERTICAL)
        self.scbProtocol.grid(row = 0, column = 3, sticky = "NSW")
        self.lbxProtocol["yscrollcommand"] = self.scbProtocol.set
        self.scbProtocol["command"] = self.lbxProtocol.yview
        #
        self.ClearAll()
        #
    #---------------------------------------------------------------------
    #
    def Line(self, line):
        self.lbxProtocol.insert(TKI.END, line)
        self.lbxProtocol.itemconfig(TKI.END, {'bg':'#efffdf'})
        self.lbxProtocol.selection_clear(0, TKI.END)
        self.lbxProtocol.selection_set('end')
        self.lbxProtocol.see('end')
        return
    #
    def AddGCodeList(self, gcodelist):
        self.Line('*** GCodeList[{0}]:'.format(len(gcodelist)))
        CI = 0
        for GCode in gcodelist:
            CI += 1
            self.Line('%3.3u> %s' % (CI, GCode.Text()))
        return
    #
    def ClearAll(self):
        self.lbxProtocol.delete(0, TKI.END)
        return
    #
    def WriteToFile(self):
        FT = (('Protocolfiles', '*.txt'),
              ('All files', '*.*'))
        FN = DEF.FILENAME_PROTOCOLGCODE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.txt',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            #
            F = open(FN, 'w')
            print('...')
            if (None != F):
                for Line in self.lbxProtocol.get(0, TKI.END):
                    F.write(Line + '\r')
                F.close()
                return True
            return False
            #
        return False
    #
    #
#
#





