import tkinter as TKI
from PIL import Image, ImageTk
from enum import Enum as ENM
#
class CFramePosition(TKI.Frame):
    def __init__(self, frameparent,
                 width, height, sizex, sizey,
                 header, namet, nameb,
                 positionactual, positiontarget):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        #
        self.Header = header
        self.NameT = namet
        self.NameB = nameb
        self.CommandA = 'Move Absolute'
        self.CommandR = 'Move Relative'
        #
        self.SX = width
        self.SY = height
        self.DY = 20
        #
        self.lblHeader = TKI.Label(self, text=self.Header)
        self.lblHeader.place(x=0, y=0, width=self.SX,
                             height=self.DY, anchor='nw')
        #
        self.lblNameT = TKI.Label(self, text=self.NameT)
        self.lblNameT.place(x=0, y=20, width=self.SX,
                           height=self.DY, anchor='nw')
        #
        self.entEditT = TKI.Spinbox(self, justify='center',
                                    from_= -1000.0, to = +1000.0,
                                    format='%+9.3f')
        self.entEditT.place(x=0, y=40, width=self.SX,
                           height=self.DY, anchor='nw')
        self.SetText(self.entEditT, '%+9.3f' % (positiontarget))
        #
        self.lblNameB = TKI.Label(self, text=self.NameB)
        self.lblNameB.place(x=0, y=60, width=self.SX,
                           height=self.DY, anchor='nw')

        self.entEditB = TKI.Spinbox(self, justify='center',
                                    from_= -1000.0, to = +1000.0,
                                    format='%+9.3f')
        self.entEditB.place(x=0, y=80, width=self.SX,
                           height=self.DY, anchor='nw')
        self.SetText(self.entEditB, '%+9.3f' % (positionactual))
        #
        self.btnCommand = TKI.Button(self, text=self.CommandA,
                                     command=self.OnButtonClick)
        self.btnCommand.place(x=0, y=self.SY, width=self.SX,
                              height=self.DY, anchor='sw')
        self.btnCommand.bind("<Button-3>", self.OnMouseClickRight)
        #
        self.OnMoveAbsolute = None
        self.OnMoveRelative = None
        #
        return
    #
    #--------------------------------------------------
    # Property - private
    #--------------------------------------------------
    def SetText(self, widget, text):
        widget.delete(0, TKI.END)
        widget.insert(0,text)
        return
    #
    def OnMouseClickRight(self, event):
        T = float(self.entEditT.get())
        A = float(self.entEditB.get())
        if (self.CommandA == self.btnCommand['text']):
            self.btnCommand['text'] = self.CommandR
            self.SetText(self.entEditT, '%+9.3f' % (T - A))
        else:
            self.btnCommand['text'] = self.CommandA
            self.SetText(self.entEditT, '%+9.3f' % (T + A))
    #
    #--------------------------------------------------
    # Property - public
    #--------------------------------------------------
    def SetOnMoveAbsolute(self, onmoveabsolute):
        self.OnMoveAbsolute = onmoveabsolute
        return
    def SetOnMoveRelative(self, onmoverelative):
        self.OnMoveRelative = onmoverelative
        return
    #
    def SetPositionTarget(self, pt):
        self.SetText(self.entEditT, '%+9.3f' % (pt))
    def SetPositionActual(self, pa):
        self.SetText(self.entEditB, '%+9.3f' % (pa))
    #
    #--------------------------------------------------
    # Callback - private
    #--------------------------------------------------
    def OnButtonClick(self):
        T = float(self.entEditT.get())
        A = float(self.entEditB.get())
        if (self.CommandA == self.btnCommand['text']): # absolute
            if (None != self.OnMoveAbsolute):
                self.OnMoveAbsolute(A, T)
        elif (self.CommandR == self.btnCommand['text']): # relative
            if (None != self.OnMoveRelative):
                self.OnMoveRelative(A, T)
        return
    #
#
#

