#
# ------------------------------------------------------------------
#   FrameSetupGlobal
# ------------------------------------------------------------------
#   Version: 00V01
#   Date   : 221013
#   Time   : 1031
#   Author : OMDevelop
#
import tkinter as TKI
from tkinter import filedialog as TKFD
#
import Define as DEF
#import Helper as HLP
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                 = 'FrameSetupGlobal'
#
#NAME_ISOPEN                     = 'IsOpen'
#INIT_ISOPEN                     = 'False'
#
TEXT_LOADEXECUTEGCODEFILE        = 'Load & Execute GCode-File'
TEXT_ABORTEXECUTION              = 'Abort Execution'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameSetupGlobal(TKI.Frame):
    # Row0
    # Row1
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 640, height = 480, \
                           padx = DEF.PAD_X, pady = DEF.PAD_Y, bg = "#F2F2F2")
        #
        self.OnReadGCodeFile = None
        #
        self.GCodeReport = TKI.BooleanVar()
        self.GCodePlot2D = TKI.BooleanVar()
        self.GCodePlot3D = TKI.BooleanVar()
        self.GCodeHardware = TKI.BooleanVar()
        #--------------------------------------------------------------
        # Controls - Row0
        #--------------------------------------------------------------
        self.lblHeader = TKI.Label(self, text = 'Choose Device for executing G-Code-File : ')
        self.lblHeader.grid(row = 0, column = 0, columnspan = 5, sticky = 'W')
        #--------------------------------------------------------------
        # Controls - Row1
        #--------------------------------------------------------------
        self.cbxGCodeReport = TKI.Checkbutton(self, text = 'GCodeReport',
                                              variable = self.GCodeReport,
                                              command = self.CheckbuttonStateChanged)
        self.cbxGCodeReport.grid(row = 1, column = 0, sticky = 'W')
        #
        self.lblGCodeReport = TKI.Label(self, text = ':   Execute and show commented Result')
        self.lblGCodeReport.grid(row = 1, column = 1, sticky = 'W')
        #--------------------------------------------------------------
        # Controls - Row2
        #--------------------------------------------------------------
        self.cbxGCodePlot2D = TKI.Checkbutton(self, text = 'GCodePlot2D',
                                              variable = self.GCodePlot2D,
                                              command = self.CheckbuttonStateChanged)
        self.cbxGCodePlot2D.grid(row = 2, column = 0, sticky = 'W')
        #
        self.lblGCodePlot2D = TKI.Label(self, text = ':   Execute while plotting Movements in 2D')
        self.lblGCodePlot2D.grid(row = 2, column = 1, sticky = 'W')
        #--------------------------------------------------------------
        # Controls - Row3
        #--------------------------------------------------------------
        self.cbxGCodePlot3D = TKI.Checkbutton(self, text = 'GCodePlot3D',
                                              variable = self.GCodePlot3D,
                                              command = self.CheckbuttonStateChanged)
        self.cbxGCodePlot3D.grid(row = 3, column = 0, sticky = 'W')
        #
        self.lblGCodePlot3D = TKI.Label(self, text = ':   Execute while plotting Movements in 3D')
        self.lblGCodePlot3D.grid(row = 3, column = 1, sticky = 'W')
        #--------------------------------------------------------------
        # Controls - Row4
        #--------------------------------------------------------------
        self.cbxGCodeHardware = TKI.Checkbutton(self, text = 'GCodeHardware',
                                                variable = self.GCodeHardware,
                                                command = self.CheckbuttonStateChanged)
        self.cbxGCodeHardware.grid(row = 4, column = 0, sticky = 'W')
        self.cbxGCodeHardware['state'] = 'disable'
        self.cbxGCodeHardware.deselect()
        #
        self.lblGCodeHardware = TKI.Label(self, text = ':   Execute over Uart on GRBL-Hardware')
        self.lblGCodeHardware.grid(row = 4, column = 1, sticky = 'W')
        #
        self.GCodeReport.set(True)
        self.GCodePlot2D.set(True)
        self.GCodePlot3D.set(True)
        self.GCodeHardware.set(False)
        #--------------------------------------------------------------
        # Controls - Row5
        #--------------------------------------------------------------
        self.btnLoadExecuteAbort = TKI.Button(self, text = TEXT_LOADEXECUTEGCODEFILE,
                                                  width = 52,
                                                  command = self.OnLoadExecuteAbort)
        self.btnLoadExecuteAbort.grid(row = 5, column = 0,
                                      columnspan = 5, sticky = 'WE')
        #--------------------------------------------------------------
        #
        self.OnReadGCodeFile = None
        self.OnStartExecution = None
        self.OnAbortExecution = None
        #
        self.CheckbuttonStateChanged()
        return
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def GCodeHardwareEnable(self):
        self.cbxGCodeHardware['state'] = 'normal'
        # NC
        self.cbxGCodeHardware.select()
        self.CheckbuttonStateChanged()
    def GCodeHardwareDisable(self):
        self.cbxGCodeHardware['state'] = 'disable'
        self.cbxGCodeHardware.deselect()
        self.CheckbuttonStateChanged()
    #
    def SetLoadExecuteGCodeFile(self, loadexecutegcodefile):
        self.LoadExecuteGCodeFile = loadexecutegcodefile
    def SetAbortExecutionGCodeList(self, abortexecutiongcodelist):
        self.AbortExecutionGCodeList = abortexecutiongcodelist
    #
    def SetTextLoadExecute(self):
        self.btnLoadExecuteAbort['text'] = TEXT_LOADEXECUTEGCODEFILE
    def SetTextAbortExecution(self):
        self.btnLoadExecuteAbort['text'] = TEXT_ABORTEXECUTION
    #
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def CheckbuttonStateChanged(self):
        Result = self.GCodeReport.get()
        Result |= self.GCodePlot2D.get()
        Result |= self.GCodePlot3D.get()
        Result |= self.GCodeHardware.get()
        if (Result):
            self.btnLoadExecuteAbort['state'] = 'normal'
        else:
            self.btnLoadExecuteAbort['state'] = 'disable'
    #
    def OnLoadExecuteAbort(self):
        if (TEXT_LOADEXECUTEGCODEFILE == self.btnLoadExecuteAbort['text']):
            FT = (('GCode-Files', '*.gcode'),
                  ('All files', '*.*'))
            FN = ''
            FN = TKFD.askopenfilename(title = 'Load GCode-File',
                                      initialdir = './',
                                      filetypes = FT)
            if (0 < len(FN)):
                if (None != self.LoadExecuteGCodeFile):
                    self.LoadExecuteGCodeFile(FN, self.GCodeReport.get(),
                                              self.GCodePlot2D.get(),
                                              self.GCodePlot3D.get(),
                                              self.GCodeHardware.get())
        elif (TEXT_ABORTEXECUTION == self.btnLoadExecuteAbort['text']):
            if (None != self.AbortExecutionGCodeList):
                self.AbortExecutionGCodeList()
        return
    #---------------------------------------------------------------------
    # Helper
    #---------------------------------------------------------------------
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        return True
    #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        return True
    #
    #
#
#


