#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# Spyder - Preferences - Run - Execute in dedicated Console
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
#----------------------------------------------------------------------
#   RealTimePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import tkinter as TKI
from time import sleep as Sleep
#
import FrameMain as FM
import Thread as THR
import Uart as UT # conda|pip install pyserial
import Convert as CV
#
TIME_START = 0.0 # [s]
TIME_PERIOD = 30.0 # [s]
TIME_DURATION = 300.0 # [s]
AMPLITUDE_FIXED = 1.0 # [unit]
PHASE = 0 # [rad]
PERIOD_REFRESHPLOT = 1 # [ms]
global VX
global VY
global ResetPlot
global AmplitudeHigh
global AmplitudeLow
VX = []
VY = []
ResetPlot = True
AmplitudeHigh = AMPLITUDE_FIXED
AmplitudeLow = -AMPLITUDE_FIXED
#
#----------------------------------------------------------------------
#   PlotData - Simulation
#----------------------------------------------------------------------
#
def SimulateValues(ticks, xl, xh, yl, yh):
    if (TIME_DURATION <= ticks):
        xl = TIME_START
        xh = TIME_DURATION
        return [xl, xh, yl, yh]
    if (ticks <= TIME_START):
        ticks = 1 + TIME_START
    if (ticks < TIME_DURATION):
        # -> PlotWidget self.Info(str(time) + 's')
        if (ticks < TIME_PERIOD):
            xl = TIME_START
            xh = TIME_PERIOD
        else:
            xl = ticks - TIME_PERIOD
            xh = ticks
    #
    VX.append(ticks)
    A = AMPLITUDE_FIXED * (0.8 + 0.4 * RND.random()) + ticks / 30.0
    if (yh < A):
        yl = -A
        yh = +A
    VY.append(A * NP.sin(2.0 * NP.pi * ticks / TIME_PERIOD + PHASE))
    return [xl, xh, yl, yh]


#
def OnRefreshValues(ticks, xl, xh, yl, yh):
    [xl, xh, yl, yh] = SimulateValues(ticks, xl, xh, yl, yh)
    global ResetPlot
    global VX
    global VY
    global AmplitudeHigh
    global AmplitudeLow
    if (ResetPlot):
        ResetPlot = False
        xl = TIME_START
        xh = TIME_PERIOD
        AmplitudeHigh = +AMPLITUDE_FIXED
        AmplitudeLow = -AMPLITUDE_FIXED
        yl = AmplitudeLow
        yh = AmplitudeHigh
        VX = []
        VY = []
        return [VX, VY, xl, xh, yl, yh]
    LI = len(VX) - 1
    if (0 < LI):
        if (TIME_PERIOD <= VX[LI]):
            xh = VX[LI]
        Y = 1.1 * VY[LI]
        if (AmplitudeHigh < Y):
            AmplitudeHigh = 1.1 * VY[LI]
            yh = AmplitudeHigh
        if (Y < AmplitudeLow):
            AmplitudeLow = 1.1 * VY[LI]
            yl = AmplitudeLow
    return [VX, VY, xl, xh, yl, yh]
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot: begin')
    #
    ResetPlot = True
    VX = []
    VY = []
    # convert
    Convert = CV.CConvert()
    #
    MainWindow = FM.CFrameMain(TKI.Tk(), PERIOD_REFRESHPLOT, \
                               TIME_START, TIME_PERIOD, \
                               -AMPLITUDE_FIXED, +AMPLITUDE_FIXED)
    MainWindow.Plot.SetOnRefreshValues(OnRefreshValues)
    MainWindow.Execute();
    #
    print('*** RealTimePlot: end')
    #
else:
    print('Call: ')
#






