import random
from itertools import count
import matplotlib as MPL
import matplotlib.pyplot as PLT
from matplotlib.animation import FuncAnimation
#
x_values = []
y_values = []
#
def RefreshPlot(ticks):
    # Refresh Axis
    PLT.cla()
    if (ticks < 10):
        PLT.axis([0, 10, 0, 5])
    else:
        PLT.axis([ticks - 10, ticks, 0, 5])
    # Refresh Values
    x_values.append(ticks)
    y_values.append(random.randint(1, 4))
    PLT.plot(x_values, y_values)
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    Animation = FuncAnimation(PLT.gcf(), RefreshPlot, frames=None, interval=100)
    # NC PLT.subplots_adjust()
    # NC PLT.tight_layout()
    PLT.show()
    #
    print('*** RealTimePlot2D: end')
