import random
from itertools import count
import matplotlib as MPL
import matplotlib.pyplot as PLT
from matplotlib.animation import FuncAnimation
import tkinter as TKI
#
import Define as DEF
import FrameMain as FMN
#
VX = []
VY = []
#
def OnRefreshPlot(ticks, xlimitlow, xlimithigh, ylimitlow, ylimithigh):
    # Refresh Axis Values
    YLimitLow = DEF.LIMIT_Y_LOW
    YLimitHigh = DEF.LIMIT_Y_HIGH
    if (ticks < 10):
        XLimitLow = DEF.LIMIT_X_LOW
        XLimitHigh = DEF.LIMIT_X_HIGH
    else:
        XLimitLow = ticks - 10
        XLimitHigh = ticks
    # Refresh Plot Values
    VX.append(ticks)
    VY.append(random.randint(1, 99))
    # Plot ... (Only at THIS point! Select here styles!)
    PLT.plot(VX, VY, linestyle='solid', color='#AAAAFF11', linewidth=4.8)
    return [VX, VY, XLimitLow, XLimitHigh, YLimitLow, YLimitHigh]
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    MainWindow = FMN.CFrameMain(TKI.Tk(), DEF.PERIOD_REFRESHPLOT_MS, \
                                DEF.LIMIT_X_LOW, DEF.LIMIT_X_HIGH, \
                                DEF.LIMIT_Y_LOW, DEF.LIMIT_Y_HIGH)
    MainWindow.Plot.SetOnRefreshPlot(OnRefreshPlot)
    MainWindow.Execute();
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
