#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
    import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
#----------------------------------------------------------------------
class CPlot():
    #
    def __init__(self, parent, periodrefresh, xl, xh, yl, yh):
        self.Parent = parent
        self.PeriodRefresh = periodrefresh
        self.OnRefreshPlot = None
        F, A = PLT.subplots(figsize=(6, 6), dpi=100)
        self.Figure = F
        self.Axes = A
        PLT.axis('equal')
        self.PlotData, = self.Axes.plot([], [], 'ro')
        #
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        #self.Toolbar = NavigationToolbar2Tk(self.Canvas, window)
        self.Canvas.get_tk_widget().pack(side=TKI.TOP, fill=TKI.BOTH, expand=1)
        self.OnInfo = None
        # later on init:
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.XL = xl
        self.XH = xh
        self.YL = yl
        self.YH = yh
        self.Axes.set_xlim([self.XL, self.XH])
        self.Axes.set_ylim([self.YL, self.YH])
        self.VX = []
        self.VY = []
        self.RefreshPlot()
    #
    def SetOnInfo(self, oninfo):
        self.OnInfo = oninfo
    #
    def SetOnRefreshPlot(self, onrefreshplot):
        self.OnRefreshPlot = onrefreshplot
    #
    def Info(self, text):
        if (None != self.OnInfo):
            self.OnInfo(text)
    #
    def RefreshPlot(self, ticks=0):
        ticks += 1
        if (None != self.OnRefreshPlot):
            PlotParameter = self.OnRefreshPlot(ticks, \
                                               self.XL, self.XH, \
                                               self.YL, self.YH)
            self.VX = PlotParameter[0]
            self.VY = PlotParameter[1]
            self.XL = PlotParameter[2]
            self.XH = PlotParameter[3]
            self.YL = PlotParameter[4]
            self.YH = PlotParameter[5]
        if (0 < len(self.VX)):
            self.PlotData.set_xdata(self.VX)
            self.PlotData.set_ydata(self.VY)
            self.Axes.set_xlim([self.XL, self.XH])
            self.Axes.set_ylim([self.YL, self.YH])
            self.Canvas.draw()
            self.Canvas.flush_events()
            self.Parent.after(self.PeriodRefresh, self.RefreshPlot, ticks)
        else:
            self.Parent.after(1000, self.RefreshPlot, ticks)
    #
    #
#
#
