#
import time as TIM
import random as RND
import numpy as NUM
import matplotlib.pyplot as PLT
#
import Task as TSK
import FrameMain as FMN
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
#
#---------------------------------------------------------
# Field - Global
#---------------------------------------------------------
MainWindow = FMN.CFrameMain()
#
global VX, VY, Counter
VX = []
VY = []
Counter = 0
#
#---------------------------------------------------------
# Callback -
#---------------------------------------------------------
def OnTaskRefreshDataStart(task):
    global VX, VY, Counter
    print('OnTaskRefreshDataStart[{0}]: begin'.format(task.ID))
    VX = []
    VY = []
    Counter = RANGE_X
    for I in range(0, 1 + Counter):
        X = I
        Y = 10.0 * RND.random()
        VX.append(X)
        VY.append(Y)
    print('OnTaskRefreshDataStart[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshDataAbort(task):
    global VX, VY, Counter
    print('OnTaskRefreshDataAbort[{0}]: begin'.format(task.ID))
    print('OnTaskRefreshDataAbort[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshDataExecute(task):
    global VX, VY, Counter
    # debug print('OnTaskRefreshDataExecute[{0}]: begin'.format(task.ID))
    if (RANGE_X <= len(VX)):
        del VX[0]
        del VY[0]
        Counter += 1
        X = Counter
        Y = 5.0 + (2.0 * RND.random() - 1.0)
        Y += 4.0 * NUM.sin(X / 10.0)
        VX.append(X)
        VY.append(Y)
        XL = VX[0] - 1
        XH = VX[-1] + 1
        YL = 0.0
        YH = 10.0
        # !!! Refresh Plot with new data/extrema !!!
        MainWindow.Plot.Refresh(VX, VY, XL, XH, YL, YH)
        TIM.sleep(0.01)
    # debug print('OnTaskRefreshDataExecute[{0}]: end'.format(task.ID))
    return
#
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2DRefreshData: begin')
    #
    TaskRefreshData = TSK.CTask('TaskRefreshData',
                                OnTaskRefreshDataStart,
                                OnTaskRefreshDataAbort,
                                OnTaskRefreshDataExecute)
    TaskRefreshData.Start()
    #
    MainWindow.Execute();
    #
    TaskRefreshData.Abort()
    #
    print('*** RealTimePlot2DRefreshData: end')
    #
    #
#
#
##########################################################
#
#
