#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
#----------------------------------------------------------------------
class CPlot():
    #
    def __init__(self, parent):
        self.Parent = parent
        F, A = PLT.subplots(figsize=(10, 8), dpi=100)
        # alternative:
        #F = PLT.figure()
        #A = F.add_subplot(111)
        #
        self.Figure = F
        self.Axes = A
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        # self.Canvas.get_tk_widget().pack(side=TKI.TOP, fill=TKI.BOTH, expand=1)
        self.Canvas.get_tk_widget().grid()#row=0, column=0, sticky='wnse')
        self.OnInfo = None
        self.VX = []
        self.VY = []
    #
    def Refresh(self, plotdatax, plotdatay, xminimum, xmaximum, yminimum, ymaximum):
        self.Axes.cla()
        self.VX = plotdatax
        self.VY = plotdatay
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_xlim([xminimum, xmaximum])
        self.Axes.set_ylim([yminimum, ymaximum])
        self.Axes.plot(self.VX, self.VY, '-', color='#FF0000', linewidth=0.8)
        self.Axes.plot(self.VX, self.VY, color='#008800', marker='o', linestyle='none')
        self.Canvas.draw()
    #
    #
#
#
