#
import sys
#
import time as TIM
import datetime as DTT
import random as RND
import numpy as NUM
import matplotlib.pyplot as PLT
#
import Task as TSK
import FrameMain as FMN
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
#
#---------------------------------------------------------
# Field - Global
#---------------------------------------------------------
global VX, VY, Counter, AbortExecute
VX = []
VY = []
Counter = 0
AbortExecute = False
#
global TaskExecute, TaskRefreshData
#
#---------------------------------------------------------
# Callback - Task - RefreshData
#---------------------------------------------------------
def OnTaskRefreshStart(task):
    global VX, VY, Counter
    #debug print('[{0}] ~~~ OnTask[{1}]-Start: begin'.format(TIM.time(), task.ID))
    VX = []
    VY = []
    Counter = RANGE_X
    for I in range(0, 1 + Counter):
        X = I
        Y = 10.0 * RND.random()
        VX.append(X)
        VY.append(Y)
    #debug print('[{0}] ~~~ OnTask[{1}]-Start: end'.format(TIM.time(), task.ID))
    return
def OnTaskRefreshAbort(task):
    global VX, VY, Counter
    #debug print('[{0}] ~~~ OnTask[{1}]-Abort: begin'.format(TIM.time(), task.ID))
    MainWindow.frmPlot.Abort()
    #debug print('[{0}] ~~~ OnTask[{1}]-Abort: end'.format(TIM.time(), task.ID))
    return
def OnTaskRefreshExecute(task):
    global VX, VY, Counter
    print('[{0}] ~~~ OnTask[{1}]-Execute: begin'.format(TIM.time(), task.ID))
    for I in range(0, 10):
        print('---')
        if (RANGE_X <= len(VX)):
            del VX[0]
            del VY[0]
            Counter += 1
            X = Counter
            Y = 5.0 + (2.0 * RND.random() - 1.0)
            Y += 4.0 * NUM.sin(X / 10.0)
            VX.append(X)
            VY.append(Y)
            XL = VX[0] - 1
            XH = VX[-1] + 1
            YL = 0.0
            YH = 10.0
            # !!! Refresh Plot with new data/extrema !!!
            MainWindow.frmPlot.Refresh(VX, VY, XL, XH, YL, YH)
        TIM.sleep(1.0)
    print('[{0}] ~~~ OnTask[{1}]-Execute: end'.format(TIM.time(), task.ID))
    return
#---------------------------------------------------------
# Callback - Task - RefreshData
#---------------------------------------------------------
def OnTaskExecuteStart(task):
    global TaskRefreshData
    #debug print('[{0}] ### OnTask[{1}]-Start: begin'.format(TIM.time(), task.ID))
    #debug print('[{0}] ### OnTask[{1}]-Start: end'.format(TIM.time(), task.ID))
    return
def OnTaskExecuteAbort(task):
    global TaskRefreshData, AbortExecute
    #debug print('[{0}] ### OnTask[{1}]-Abort: begin'.format(TIM.time(), task.ID))
    TaskRefresh.Abort()
    print('[{0}] ### OnTask[{1}]-AbortExecute:=True'.format(TIM.time(), task.ID))
    AbortExecute = True
    #debug print('[{0}] ### OnTask[{1}]-Abort: end'.format(TIM.time(), task.ID))
    return
def OnTaskExecuteBusy(task):
    global TaskRefreshData
    #debug print('[{0}] ### OnTask[{1}]-Execute: begin'.format(TIM.time(), task.ID))
    #print('[{0}] ### OnTask[{1}]-waiting: begin'.format(TIM.time(), task.ID))

    for I in range(0, 2):
        print('...')
        TaskRefresh.Start()
        while TaskRefresh.IsActive():
            pass
        TaskRefresh.Abort()
    #print('[{0}] ### OnTask[{1}]-waiting: end'.format(TIM.time(), task.ID))
    #debug print('[{0}] ### OnTask[{1}]-Execute: end'.format(TIM.time(), task.ID))
    return
#---------------------------------------------------------
# Callback - MainWindow
#---------------------------------------------------------
def MainWindowOnDelete():
    #debug print('[{0}] *** MainWindowOnDelete: begin'.format(TIM.time()))
    TaskExecute.Abort()
    #debug print('[{0}] *** MainWindowOnDelete: end'.format(TIM.time()))
    return
#---------------------------------------------------------
# Global Field
#---------------------------------------------------------
TaskRefresh = TSK.CTask('TaskRefresh',
                        OnTaskRefreshStart,
                        OnTaskRefreshAbort,
                        OnTaskRefreshExecute)
TaskExecute = TSK.CTask('TaskExecute', OnTaskExecuteStart,
                        OnTaskExecuteAbort, OnTaskExecuteBusy)
MainWindow = FMN.CFrameMain(MainWindowOnDelete)
#
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    sys.stdout.flush()
    print('[{0}] *** RealTimePlot2DRefreshData: begin'.format(TIM.time()))
    #
    TaskExecute.Start()
    #
    MainWindow.Execute();
    #
    # NC - see OnDeleteWindow - TaskExecute.Abort()
    #
    TaskExecute.Abort()
    #
    print('[{0}] *** RealTimePlot2DRefreshData: end'.format(TIM.time()))
    #
    #
#
#
##########################################################
#
#
