#
import time as TIM
import random as RND
import numpy as NUM
import matplotlib.pyplot as PLT
#
import Task as TSK
import FrameMain as FMN
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 100
PLOT_SCALE = 0.2
#
#---------------------------------------------------------
# Field - Global
#---------------------------------------------------------
MainWindow = FMN.CFrameMain()
#
global VX, VY, XL, XH, YL, YH
global Counter
global TaskRefresh, TaskAction
VX = []
VY = []
XL = 0.0
XH = 100.0
YL = 0.0
YH = 100.0
Counter = 0
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskRefreshStart(task):
    return
def OnTaskRefreshAbort(task):
    global VX, VY, Counter
    #print('OnTaskRefreshAbort[{0}]: begin'.format(task.ID))
    #print('OnTaskRefreshAbort[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshExecute(task):
    global VX, VY, XL, XH, YL, YH
    # debug print('OnTaskRefreshExecute[{0}]: begin'.format(task.ID))
    MainWindow.Plot.Refresh(VX, VY, XL, XH, YL, YH)
    TIM.sleep(0.001)
    # debug print('OnTaskRefreshExecute[{0}]: end'.format(task.ID))
    return
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def OnTaskActionStart(task):
    global VX, VY, XL, XH, YL, YH, TaskRefresh
    print('OnTaskRefreshStart[{0}]: begin'.format(task.ID))
    VX = []
    VY = []
    Counter = 0
    XL = 0.0
    XH = 100.0
    YL = 0.0
    YH = 100.0
    for I in range(0, 1 + RANGE_X):
        X = I
        Y = 20.0 * RND.random() - 10.0 + 50.0 + 40.0 * NUM.sin(X/20)
        VX.append(X)
        VY.append(Y)
    TaskRefresh.Start()
    print('OnTaskRefreshStart[{0}]: end'.format(task.ID))
    return
def OnTaskActionAbort(task):
    global VX, VY, XL, XH, YL, YH, TaskRefresh
    TaskRefresh.Abort()
    return
def OnTaskActionExecute(task):
    global VX, VY, XL, XH, YL, YH, TaskRefresh, Counter
    while (task.IsBusy()):
        if (RANGE_X <= len(VX)):
            XL = Counter - RANGE_X
            YL = 0.0
            del VX[0]
            del VY[0]
            Counter += 1
            X = Counter
            Y = 20.0 * RND.random() - 10.0 + 50.0 + 40.0 * NUM.sin(X/20)
            VX.append(X)
            VY.append(Y)
            XH = X
            YH = 100.0
        # !!!!!!!!!!!!! TIM.sleep(1.0)
        TIM.sleep(0.001)
    # error TaskRefresh.Abort()
    return
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2DRefreshData: begin')
    #
    TaskRefresh = TSK.CTask('TaskRefreshData',
                            OnTaskRefreshStart,
                            OnTaskRefreshAbort,
                            OnTaskRefreshExecute)
    TaskAction = TSK.CTask('TaskAction',
                           OnTaskActionStart,
                           OnTaskActionAbort,
                           OnTaskActionExecute)
    TaskAction.Start()
    #
    MainWindow.Execute();
    #
    TaskAction.Abort()
    #
    print('*** RealTimePlot2DRefreshData: end')
    #
    #
#
#
##########################################################
#
#
