import time as TIM
import random as RND
import numpy as NUM
#
import tkinter as TKI
from tkinter import ttk as TTK
#
import Task as TSK
import FrameApplication as FRA
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
RANGE_X = 10
PLOT_SCALE = 0.2
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global VX, VY, XL, XH, YL, YH
global Counter
global TaskRefresh, TaskAction
VX = []
VY = []
Counter = 0
XL = 0.0
XH = 10.0
YL = 0.0
YH = 10.0
#
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskRefreshStart(task):
    return
def OnTaskRefreshAbort(task):
    global VX, VY, Counter
    #print('OnTaskRefreshAbort[{0}]: begin'.format(task.ID))
    #print('OnTaskRefreshAbort[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshExecute(task):
    global VX, VY, XL, XH, YL, YH
    # debug print('OnTaskRefreshExecute[{0}]: begin'.format(task.ID))
    FrameApplication.tbsPlot2D.Refresh(VX, VY, XL, XH, YL, YH)
    TIM.sleep(0.001)
    # debug print('OnTaskRefreshExecute[{0}]: end'.format(task.ID))
    return
#
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def OnTaskActionStart(task):
    global VX, VY, XL, XH, YL, YH, Counter, TaskRefresh
    print('OnTaskRefreshStart[{0}]: begin'.format(task.ID))
    for I in range(0, 1 + RANGE_X):
        X = I
        Y = 2.0 * RND.random() - 1.0 + 5.0 + 4.0 * NUM.sin(0.1 * X)
        VX.append(X)
        VY.append(Y)
    TaskRefresh.Start()
    print('OnTaskRefreshStart[{0}]: end'.format(task.ID))
    return
def OnTaskActionAbort(task):
    global TaskRefresh
    TaskRefresh.Abort()
    return
def OnTaskActionExecute(task):
    global VX, VY, XL, XH, YL, YH, Counter #, TaskRefresh
    while (task.IsBusy()):
        if (RANGE_X <= len(VX)):
            XL = Counter - RANGE_X
            YL = 0.0
            del VX[0]
            del VY[0]
            Counter += 1
            X = Counter
            Y = 2.0 * RND.random() - 1.0 + 5.0 + 4.0 * NUM.sin(0.1 * X)
            VX.append(X)
            VY.append(Y)
            XH = X
            YH = 10.0
            # necessary:      !!!!!!!!!!!!!!
            TIM.sleep(0.001) #!!!!!!!!!!!!!!
    return
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk())
    #
    TaskRefresh = TSK.CTask('TaskRefreshData',
                            OnTaskRefreshStart,
                            OnTaskRefreshAbort,
                            OnTaskRefreshExecute)
    TaskAction = TSK.CTask('TaskAction',
                           OnTaskActionStart,
                           OnTaskActionAbort,
                           OnTaskActionExecute)
    TaskAction.Start()
    #
    FrameApplication.Execute()
    #
    TaskAction.Abort()
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
###################################################################
# NC !!! FrameApplication.grid(row=0, column=0) # !!! (was) important !!!
