#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import tkinter as TKI
from tkinter import ttk as TTK
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
#----------------------------------------------------------------------
DOTSPERINCH = 100
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        self.FrameParent.rowconfigure(0, weight=6)
        self.FrameParent.columnconfigure(0, weight=6)
        self.FrameParent.grid(row=0, column=0, sticky='wnse')
        #
        self.rowconfigure(0, weight=6)
        self.columnconfigure(0, weight=6)
        self.Figure, self.Axes = PLT.subplots(figsize=(800 / DOTSPERINCH,
                                                       600 / DOTSPERINCH),
                                              dpi=DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self) # not[.FrameParent]!
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='wnse') #
        self.VX = []
        self.VY = []
        #
        return
    #
    def Refresh(self, plotdatax, plotdatay, xminimum, xmaximum, yminimum, ymaximum):
        self.Axes.cla()
        self.VX = plotdatax
        self.VY = plotdatay
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_xlim([xminimum, xmaximum])
        self.Axes.set_ylim([yminimum, ymaximum])
        self.Axes.plot(self.VX, self.VY, '-', color='#FF0000', linewidth=0.8)
        self.Axes.plot(self.VX, self.VY, color='#008800', marker='o', linestyle='none')
        self.Canvas.draw()
        return
    #
    #
#
#
