import tkinter as TKI
from tkinter import ttk as TTK
#
import FramePlot2D as FP2D
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #
        self.FrameParent.geometry('804x626+2022+22')
        self.FrameParent.title(TITLE_APPLICATION)
        #
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        self.FrameParent.rowconfigure(0, weight=6)
        self.FrameParent.columnconfigure(0, weight=6)
        #--------------------------------------------------------
        # Notebook - Main
        #--------------------------------------------------------
        self.ntbMain = TTK.Notebook(self.FrameParent)
        self.ntbMain.grid(row=1, column=1, sticky='wnes')
        #--------------------------------------------------------
        # Notebook - Tabsheet - Plot2D
        #--------------------------------------------------------
        self.tbsPlot2D = FP2D.CFramePlot2D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot2D, text='Plot2D')
        #
        return
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        # debug print('OnWMWindowDelete')
        # self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
    #
    #
#
#
