# NC
import time as TIM
import random as RND
import numpy as NUM
#
import tkinter as TKI
# NC from tkinter import ttk as TTK
#
import Define as DEF
import Task as TSK
import FrameApplication as FRA
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
REFRESH_DELTA = 10
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global VX, VY, XL, XH, YL, YH
global TaskDisplayPlotdata, TaskAction, EventDisplayReady
#
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskDisplayPlotdataStart(task):
    global EventDisplayReady
    # debug print('OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
    EventDisplayReady.Clear()
    # debug print('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
    return
def OnTaskDisplayPlotdataAbort(task):
    global EventDisplayReady
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
    EventDisplayReady.Clear()
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
    return
def OnTaskDisplayPlotdataExecute(task):
    global VX, VY, XL, XH, YL, YH
    global EventDisplayReady
    # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
    try:
        IL = 0
        IH = len(VX) - 1
        for I in range(IL, REFRESH_DELTA + IH, REFRESH_DELTA):
            IA = min(100, I)
            FrameApplication.tbsPlot2D.Refresh(VX, VY, IL, IA, IH,
                                               XL, XH, YL, YH)
            # debug TIM.sleep(1.0)
        EventDisplayReady.Set()
    except:
        pass
    # debug print('OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
    return False
#
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def Function(x): # 20 10
    return 26.0 * RND.random() - 13.0 + 50.0 + 30.0 * NUM.sin(0.1 * x)
#
def OnTaskCreatePlotdataStart(task):
    # debug print('OnTaskCreatePlotdataStart[{0}]: begin'.format(task.ID))
    # debug print('OnTaskCreatePlotdataStart[{0}]: end'.format(task.ID))
    return
def OnTaskCreatePlotdataAbort(task):
    global TaskCreatePlotdata, TaskDisplayPlotdata
    TaskDisplayPlotdata.Abort()
    return
def OnTaskCreatePlotdataExecute(task):
    global VX, VY, XL, XH, YL, YH
    global EventDisplayReady
    global TaskCreatePlotdata, TaskDisplayPlotdata
    try:
        while (task.IsBusy()):
            EventDisplayReady.Set()
            # Create Plotdata
            VX = []
            VY = []
            XL = 0.0
            YL = 0.0
            XH = 100.0
            YH = 100.0
            for I in range(0, DEF.RANGE_X):
                X = I
                Y = Function(X)
                VX.append(X)
                VY.append(Y)
            # Display Plotdata
            EventDisplayReady.Clear()
            TaskDisplayPlotdata.Start()
            EventDisplayReady.Wait()
            # debug            TIM.sleep(1.0)
    except:
        return False
    return TaskCreatePlotdata.IsBusy()
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    # debug print('OnFrameApplicationDelete')
    if (TaskCreatePlotdata.IsBusy()):
        TaskCreatePlotdata.Abort()
    return
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)
    #
    VX = []
    VY = []
    XL = 0.0
    XH = 10.0
    YL = 0.0
    YH = 10.0
    #
    EventDisplayReady = TSK.CEvent()
    TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                    OnTaskDisplayPlotdataStart,
                                    OnTaskDisplayPlotdataAbort,
                                    OnTaskDisplayPlotdataExecute)
    TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                   OnTaskCreatePlotdataStart,
                                   OnTaskCreatePlotdataAbort,
                                   OnTaskCreatePlotdataExecute)
    TaskCreatePlotdata.Start()
    #
    FrameApplication.Execute()
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
###################################################################
# NC !!! FrameApplication.grid(row=0, column=0) # !!! (was) important !!!
