#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import tkinter as TKI
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
import Define as DEF
#
#----------------------------------------------------------------------
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        self.FrameParent.rowconfigure(0, weight=1)
        self.FrameParent.columnconfigure(0, weight=1)
        #
        self.Figure, self.Axes = PLT.subplots(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                              DEF.DOTS_Y / DEF.DOTSPERINCH),
                                              dpi=DEF.DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.FrameParent) #(!!!)
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='nswe')
        #
        self.VX = []
        self.VY = []
        self.XL = 0.0
        self.XH = 100.0
        self.YL = 0.0
        self.YH = 100.0
        self.Title = 'Plot2D'
        self.XLabel = 'X [mm]'
        self.YLabel = 'Y [mm]'
        self.LineColor = '#ccccff'
        self.LineStyle = 'solid'
        self.LineWidth = 1.8
        self.LineMarker = '.'
        #
        self.Rescale()
        return
    #
    def SetVX(self, data):
        self.VX = data
    def SetVY(self, data):
        self.VY = data
    #
    def SetXL(self, data):
        self.XL = data
    def SetXH(self, data):
        self.XH = data
    def SetYL(self, data):
        self.YL = data
    def SetYH(self, data):
        self.YH = data
    #
    def SetTitle(self, data):
        self.Title = data
    def SetXLabel(self, data):
        self.XLabel = data
    def SetYLabel(self, data):
        self.YLabel = data
    def SetLineColor(self, data):
        self.LineColor = data
    def SetLineStyle(self, data):
        self.LineStyle = data
    def SetLineWidth(self, data):
        self.LineWidth = data
    def SetLineMarker(self, data):
        self.LineMarker = data
    #
    def Rescale(self):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('auto')
        self.Axes.set_aspect('auto', 'box')
        PLT.title(self.Title)
        PLT.xlabel(self.XLabel)
        PLT.ylabel(self.YLabel)
        PLT.xlim([self.XL, self.XH])
        PLT.ylim([self.YL, self.YH])
        return
    #
    def Plot(self):
        self.Rescale()
        if (0 < len(self.VX)):
            self.Axes.plot(self.VX, self.VY,
                           color=self.LineColor,
                           linestyle=self.LineStyle,
                           linewidth=self.LineWidth,
                           marker=self.LineMarker)
            self.Canvas.draw()
        return
    #
    #
#
#
