#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import random as RND
import numpy as NUM
import tkinter as TKI
# NC from tkinter import ttk as TTK
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
import Define as DEF
import Task as TSK
#
#----------------------------------------------------------------------
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        #
        # !!! self.rowconfigure(0, weight=1) #=6
        # self.columnconfigure(0, weight=6)
        #
        #self.FrameParent.grid(row=0, column=0) #, sticky='wnse')
        #
        self.Figure, self.Axes = PLT.subplots(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                                       DEF.DOTS_Y / DEF.DOTSPERINCH),
                                              dpi=DEF.DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self) # not[.FrameParent]!
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='wnse') #
        #
        self.TimePeriod = 300 # DEF.TIMEPERIOD_PLOT_MS
        #
        self.VX = []
        self.VY = []
        self.PresetX = []
        self.PresetY = []
        for I in range(0, DEF.RANGE_X):
            self.VX.append(I)
            self.VY.append(self.Function(I))
            self.PresetX.append(I)
            self.PresetY.append(self.Function(I))
        self.XL = 0.0
        self.XH = 100.0
        self.YL = 0.0
        self.YH = 100.0
        self.Title = 'Plot2D'
        self.XLabel = 'X [mm]'
        self.YLabel = 'Y [mm]'
        self.LineColor = '#ccccff'
        self.LineStyle = 'solid'
        self.LineWidth = 1.8
        # #
        # #self.EventTriggerPlot = TSK.CEvent()
        # #self.EventTriggerPlot.Set()
        self.Rescale()
        self.RefreshPeriodic()
        # #self.EventTriggerPlot.Clear()
        return
    # #
    # def SetTimePeriodic(self, data):
    #     self.TimePeriod = data
    #
    def SetVX(self, data):
        self.PresetX = data.copy()
    def SetVY(self, data):
        self.PresetY = data.copy()
    #
    def SetXL(self, data):
        self.XL = data
    def SetXH(self, data):
        self.XH = data
    def SetYL(self, data):
        self.YL = data
    def SetYH(self, data):
        self.YH = data
    #
    # def SetTitle(self, data):
    #     self.Title = data
    # def SetXLabel(self, data):
    #     self.XLabel = data
    # def SetYLabel(self, data):
    #     self.YLabel = data
    def SetLineColor(self, data):
        self.LineColor = data
    # def SetLineStyle(self, data):
    #     self.LineStyle = data
    # def SetLineWidth(self, data):
    #     self.LineWidth = data
    # #
    def Function(self, x):
        # return 26.0 * RND.random() - 13.0 + 50.0 + 30.0 * NUM.sin(0.1 * x)
        return x
    #
    def Rescale(self):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_title(self.Title)
        self.Axes.set_xlabel(self.XLabel)
        self.Axes.set_ylabel(self.YLabel)
        self.Axes.set_xlim([self.XL, self.XH])
        self.Axes.set_ylim([self.YL, self.YH])
        return
    #
    def RefreshPeriodic(self):
        if (0 < len(self.VX)):
            # self.VX = []
            # self.VY = []
            for I in range(0, DEF.RANGE_X):
                self.VX[I] = self.PresetX[I]
                self.VY[I] = self.PresetY[I]
            self.Rescale()
            self.Axes.plot(self.VX, self.VY,
                            color=self.LineColor,
                            linestyle=self.LineStyle,
                            linewidth=self.LineWidth)
            self.Canvas.draw()
        #self.EventTriggerPlot.Wait()
        self.FrameParent.after(self.TimePeriod, self.RefreshPeriodic)
        #self.TimePeriod = 100 # lower values are critical!
        return
    #
    def Refresh(self, timeperiodic):
        self.TimePeriod = timeperiodic
        #self.EventTriggerPlot.Set()
        #self.EventTriggerPlot.Clear()
        return
    #
    #
#
#
