import tkinter as TKI
from tkinter import ttk as TTK
#
import FrameChild as FRC
import FrameTest as FRT
import FramePlot2D as FP2D
import FramePlot3D as FP3D
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #
        #self.FrameParent.geometry('606x630+222+222')
        self.FrameParent.geometry('606x630+2122+122')
        self.FrameParent.title(TITLE_APPLICATION)
        #
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        self.FrameParent.rowconfigure(0, weight=6)
        self.FrameParent.rowconfigure(1, weight=6)
        self.FrameParent.columnconfigure(0, weight=6)
        self.FrameParent.columnconfigure(1, weight=6)
        #
        self.ntbMain = TTK.Notebook(self.FrameParent) # bg='#ffAA66')
        self.ntbMain.grid(row=1, column=1, sticky='wnes')
        #--------------------------------------------------------
        # F3D
        #--------------------------------------------------------
        self.tbsPlot3D = FP3D.CFramePlot3D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot3D, text='Tabsheet: Plot3D')
        #--------------------------------------------------------
        # FA
        #--------------------------------------------------------
        self.tbsPlot2DA = FP2D.CFramePlot2D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot2DA, text='Tabsheet: Plot2DA')
        self.tbsPlot2DA.SetLineColor('#ff8888')
        #--------------------------------------------------------
        # F01
        #--------------------------------------------------------
        self.tbsPlot2DB = FP2D.CFramePlot2D(self.ntbMain)
        self.ntbMain.add(self.tbsPlot2DB, text='Tabsheet: Plot2DB')
        self.tbsPlot2DB.SetLineColor('#88ff88')
        #--------------------------------------------------------
        # F..
        #--------------------------------------------------------
        self.tbsChild10 = FRC.CFrameChild(self.ntbMain)
        self.ntbMain.add(self.tbsChild10, text='Tabsheet: Child10')
        #--------------------------------------------------------
        # F12
        #--------------------------------------------------------
        self.tbsTest01 = FRT.CFrameTest(self.ntbMain)
        self.ntbMain.add(self.tbsTest01, text='Tabsheet: Test01')
        #
        return
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        # self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
