import time as TIM
import random as RND
import numpy as NUM
import tkinter as TKI
#
import Define as DEF
import Task as TSK
import FrameApplication as FRA
#


#---------------------------------------------------------
# Field - 2D
#---------------------------------------------------------
VX2D = []
VY2D = []
XL2D = 0.0
XH2D = 100.0
YL2D = 0.0
YH2D = 100.0
#---------------------------------------------------------
# Field - 3D
#---------------------------------------------------------
VX3D = []
VY3D = []
VZ3D = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 1024
Direction = True
GlobalTicks = 0
#
#---------------------------------------------------------
# Callback - Task
#---------------------------------------------------------
def Function(x): # 20 10
    return 26.0 * RND.random() - 13.0 + 50.0 + 30.0 * NUM.sin(0.1 * x)
#
def OnTaskPlotdataStart(task):
    FrameApplication.tbsPlot3D.SetTimePeriodic(DEF.TIMEPERIOD_PLOT_MS)
    #
    FrameApplication.tbsPlot2DA.Refresh(DEF.TIMEPERIOD_PLOT_MS)
    FrameApplication.tbsPlot2DB.Refresh(DEF.TIMEPERIOD_PLOT_MS)
    return
def OnTaskPlotdataAbort(task):
    FrameApplication.tbsPlot3D.SetTimePeriodic(DEF.TIMEPERIOD_IDLE_MS)
    #
    FrameApplication.tbsPlot2DA.Refresh(DEF.TIMEPERIOD_IDLE_MS)
    FrameApplication.tbsPlot2DB.Refresh(DEF.TIMEPERIOD_IDLE_MS)
    return
def OnTaskPlotdataExecute(task):
    #-------------------------------------------
    # Plot3D
    #-------------------------------------------
    global VX3D, VY3D, VZ3D
    global Direction, GlobalTicks
    GlobalTicks += 1
    Ticks = GlobalTicks % Modulo
    A = 20 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = 5.0 + R * NUM.cos(A)
    Y = 5.0 + R * NUM.sin(A)
    Z = -5.0 + (+5.0 - (-5.0)) * Ticks / Modulo
    if (0 == Ticks):
        VX3D = []
        VY3D = []
        VZ3D = []
    VX3D.append(X)
    VY3D.append(Y)
    VZ3D.append(Z)
    if (0 == Ticks):
        Direction = not(Direction)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimuth = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimuth = (Modulo - Ticks) / Modulo * 90.0
    FrameApplication.tbsPlot3D.SetVX(VX3D)
    FrameApplication.tbsPlot3D.SetVY(VY3D)
    FrameApplication.tbsPlot3D.SetVZ(VZ3D)
    FrameApplication.tbsPlot3D.SetXL(0.0)
    FrameApplication.tbsPlot3D.SetXH(10.0)
    FrameApplication.tbsPlot3D.SetYL(0.0)
    FrameApplication.tbsPlot3D.SetYH(10.0)
    FrameApplication.tbsPlot3D.SetZL(-5.0)
    FrameApplication.tbsPlot3D.SetZH(+5.0)
    FrameApplication.tbsPlot3D.SetElevation(Elevation)
    FrameApplication.tbsPlot3D.SetAzimuth(Azimuth)
    FrameApplication.tbsPlot3D.Refresh(1) # only Plot3D
    #-------------------------------------------
    # Plot2D
    #-------------------------------------------
    for I in range(0, DEF.RANGE_X):
        VX2D[I] = I
        VY2D[I] = Function(I)
    # Plot2DA
    FrameApplication.tbsPlot2DA.SetVX(VX2D)
    FrameApplication.tbsPlot2DA.SetVY(VY2D)
    FrameApplication.tbsPlot2DA.SetXL(XL2D)
    FrameApplication.tbsPlot2DA.SetXH(XH2D)
    FrameApplication.tbsPlot2DA.SetYL(YL2D)
    FrameApplication.tbsPlot2DA.SetYH(YH2D)
    #NCFrameApplication.tbsPlot2DA.Refresh(10) # not Plot2D
    # Plot2DB
    FrameApplication.tbsPlot2DB.SetVX(VX2D)
    FrameApplication.tbsPlot2DB.SetVY(VY2D)
    FrameApplication.tbsPlot2DB.SetXL(XL2D)
    FrameApplication.tbsPlot2DB.SetXH(XH2D + 20)
    FrameApplication.tbsPlot2DB.SetYL(YL2D)
    FrameApplication.tbsPlot2DB.SetYH(YH2D)
    #NCFrameApplication.tbsPlot2DB.Refresh(10) # not Plot2D
    #
    #debugprint('...')
    TIM.sleep(0.001201)
    return TaskPlotdata.IsBusy()
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    # debug print('OnFrameApplicationDelete')
    if (TaskPlotdata.IsBusy()):
        TaskPlotdata.Abort()
    return
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)

    VX2D = []
    VY2D = []
    for I in range(0, 102):
        VX2D.append(I)
        VY2D.append(I)
    #
    TaskPlotdata = TSK.CTask('TaskPlotdata',
                             OnTaskPlotdataStart,
                             OnTaskPlotdataAbort,
                             OnTaskPlotdataExecute)
    TaskPlotdata.Start()
    #
    FrameApplication.Execute()
    #
    if TaskPlotdata.IsBusy():
        TaskPlotdata.Abort()
    #
#
#
