#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
    import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
import Define as DEF
import Task as TSK
#
#----------------------------------------------------------------------
class CFramePlot3D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        #self.Figure = PLT.figure(figsize=(8, 8), dpi=100)
        self.Figure = PLT.figure(figsize=(6, 6), dpi=100)
        self.Axes = PLT.axes(projection='3d')
        #
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self)# NOT: .FrameParent)
        #self.Toolbar = NavigationToolbar2Tk(self.Canvas, window)
        self.Canvas.get_tk_widget().grid(row=0, column=0)
        #
        self.TimePeriod = DEF.TIMEPERIOD_IDLE_MS
        #
        self.XL = 0.0 #xl
        self.XH = 20.0 #xh
        self.YL = 0.0 #yl
        self.YH = 20.0 #yh
        self.ZL = -10.0 #zl
        self.ZH = 10.0 #zh
        self.Elevation = 30.0
        self.Azimuth = 30.0
        self.IL = 0
        self.IA = int(DEF.RANGE_X / 2)
        self.IH = DEF.RANGE_X
        self.Axes.set_xlim([self.XL, self.XH])
        self.Axes.set_ylim([self.YL, self.YH])
        self.Axes.set_zlim([self.ZL, self.ZH])
        self.VX0 = []
        self.VY0 = []
        self.VZ0 = []
        self.VX1 = []
        self.VY1 = []
        self.VZ1 = []
        self.EventTriggerPlot = TSK.CEvent()
        self.EventTriggerPlot.Set()
        self.Rescale()
        self.RefreshPeriodic()
        self.EventTriggerPlot.Clear()
        #
    #
    def SetTimePeriodic(self, data):
        self.TimePeriod = data
    #
    def SetVX(self, data):
        self.VX = data.copy()
    def SetVY(self, data):
        self.VY = data.copy()
    def SetVZ(self, data):
        self.VZ = data.copy()
    #
    def SetXL(self, data):
        return #self.XL = data
    def SetXH(self, data):
        self.XH = data
    def SetYL(self, data):
        self.YL = data
    def SetYH(self, data):
        self.YH = data
    def SetZL(self, data):
        self.ZL = data
    def SetZH(self, data):
        self.ZH = data
    #
    def SetElevation(self, data):
        self.Elevation = data
    def SetAzimuth(self, data):
        self.Azimuth = data
    #
    def Rescale(self):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('auto')
        self.Axes.set_aspect('auto', 'box')
        self.Axes.set_title("Plot3D")
        self.Axes.set_xlabel("X [mm]")
        self.Axes.set_ylabel("Y [mm]")
        self.Axes.set_zlabel("Z [mm]")
        self.Axes.set_xlim([self.XL, self.XH])
        self.Axes.set_ylim([self.YL, self.YH])
        self.Axes.set_zlim([self.ZL, self.ZH])
        #
        self.Axes.view_init(elev=self.Elevation, azim=self.Azimuth)
    #
    def RefreshPeriodic(self):
        self.Rescale()
        #self.Axes.plot3D(self.VX, self.VY, self.VZ,
        #                 linestyle='solid', color='#ff8888', linewidth=4.0)
        self.Axes.plot(self.VX1[self.IA - 1:self.IH],
                       self.VY1[self.IA - 1:self.IH],
                       self.VZ1[self.IA - 1:self.IH],
                       color='#ff000030',
                       linestyle='solid',
                       linewidth=3)
        self.Axes.plot(self.VX1[self.IL:self.IA],
                       self.VY1[self.IL:self.IA],
                       self.VZ1[self.IL:self.IA],
                       color='#ff0000',
                       linestyle='solid',
                       linewidth=3)
        self.Axes.plot(self.VX0, self.VY0, self.VZ0,
                       color='#0000ff',
                       linestyle='solid',
                       linewidth=3)
        self.Canvas.draw()
        self.Canvas.flush_events()
        #self.EventTriggerPlot.Wait()
        self.FrameParent.after(self.TimePeriod, self.RefreshPeriodic)
        return
    #
    def Refresh(self, vx0, vy0, vz0, vx1, vy1, vz1,
                        il, ia, ih, timeperiodic):
        self.TimePeriod = timeperiodic
        self.IL = il
        self.IA = ia
        self.IH = ih
        self.VX0 = vx0.copy()
        self.VY0 = vy0.copy()
        self.VZ0 = vz0.copy()
        self.VX1 = vx1.copy()
        self.VY1 = vy1.copy()
        self.VZ1 = vz1.copy()
        self.TimePeriod = timeperiodic
        self.EventTriggerPlot.Set()
        self.EventTriggerPlot.Clear()
        return
    #
    #
#
#
