# NC
import time as TIM
import random as RND
import numpy as NUM
#
import tkinter as TKI
# NC from tkinter import ttk as TTK
#
import Define as DEF
import Task as TSK
import GCodeConverter as GCV
import GCodeSimulator as GCS
import FrameApplication as FRA
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
REFRESH_DELTA = 10
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
#global VX, VY, XL, XH, YL, YH
global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
global GCodeList, GCodeLines
GCodeList = []
GCodeLines = []
# #
# #---------------------------------------------------------
# # Callback - Task - Refresh
# #---------------------------------------------------------
def OnTaskDisplayPlotdataStart(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    # debug print('OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
    EventDisplayReady.Clear()
    # debug print('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
    return
def OnTaskDisplayPlotdataAbort(task):
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
    return
#
def OnTaskDisplayPlotdataExecute(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))

    # DEF.TIME_REFRESH
    # while ()
    try:
        DT = 10 * DEF.TIME_REFRESH
        T0 = TIM.time()
        T1 = T0
        IL = 0
        IH = max(0, len(GCodeSimulator.GetVX1()) - 1)
        IA = 0
        Loop = True
        while (Loop):
            if (TIM.time() < T1 + DEF.TIME_REFRESH):
                T1 = T1 + DEF.TIME_REFRESH
                # debug print('!!!')
                IA = min(IH, 1 + IA)
                XL = GCodeSimulator.GetXL()
                XH = GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = GCodeSimulator.GetYL()
                YH = GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                FrameApplication.tbsPlot2D.RefreshI(GCodeSimulator.GetVX0(),
                                                    GCodeSimulator.GetVY0(),
                                                    GCodeSimulator.GetVX1(),
                                                    GCodeSimulator.GetVY1(),
                                                    IL, IA, IH,
                                                    XL, XH, YL, YH)
                # TIM.sleep(0.001)
            else:
                # debug print('...')
                TIM.sleep(0.001)
            #
            if (DT <= T1 - T0):
                Loop = False
            #
        # debug print('...SET...')
        EventDisplayReady.Set()
        # debug print('!!!!!!!! OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
    except:
        print('????????? Error')
    return False

    # print('DT[{0}]'.format(TIM.time() - T0))
    # TIM.sleep(0.01)
    # print('DT[{0}]'.format(TIM.time() - T0))
#
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def OnTaskCreatePlotdataStart(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    return
def OnTaskCreatePlotdataAbort(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    if (TaskDisplayPlotdata.IsBusy()):
        TaskDisplayPlotdata.Abort()
    return
def OnTaskCreatePlotdataExecute(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    FileEntry = 'AR.gcode'
    print('>>> Read GCodeList from File[{0}]:'.format(FileEntry))
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(FileEntry)
    print(GCodeList.Text())
    print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
    for GCode in GCodeList:
        GCodeSimulator.ExecuteGCode(GCode)
        print(len(GCodeSimulator.GetVX0()), len(GCodeSimulator.GetVX1()))
        # debug print('...start...')
        TaskDisplayPlotdata.Start()
        # debug print('...wait...')
        EventDisplayReady.Wait()
        # debug print('...ready...')
    print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
    return False
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    if (TaskCreatePlotdata.IsBusy()):
        TaskCreatePlotdata.Abort()
    return
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)
    #
    GCodeConverter = GCV.CGCodeConverter()
    GCodeSimulator = GCS.CGCodeSimulator()
    #
    EventDisplayReady = TSK.CEvent()
    TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                    OnTaskDisplayPlotdataStart,
                                    OnTaskDisplayPlotdataAbort,
                                    OnTaskDisplayPlotdataExecute)
    TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                   OnTaskCreatePlotdataStart,
                                   OnTaskCreatePlotdataAbort,
                                   OnTaskCreatePlotdataExecute)
    TaskCreatePlotdata.Start()
    #
    FrameApplication.Execute()
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
###################################################################
# NC !!! FrameApplication.grid(row=0, column=0) # !!! (was) important !!!
    # VX = []
    # VY = []
    # XL = 0.0
    # XH = 10.0
    # YL = 0.0
    # YH = 10.0

    # debug print('OnTaskCreatePlotdataStart[{0}]: begin'.format(task.ID))
    # debug print('OnTaskCreatePlotdataStart[{0}]: end'.format(task.ID))
#    global TaskCreatePlotdata, TaskDisplayPlotdata
#     TaskDisplayPlotdata.Abort()


#     global VX, VY, XL, XH, YL, YH
#     global EventDisplayReady
#     global TaskCreatePlotdata, TaskDisplayPlotdata
#     # EventDisplayReady.Set()
#     # # Create Plotdata
#     # VX = []
#     # VY = []
#     # XL = 0.0
#     # YL = 0.0
#     # XH = 100.0
#     # YH = 100.0
#     # for I in range(0, DEF.RANGE_X):
#     #     X = I
#     #     Y = Function(X)
#     #     VX.append(X)
#     #     VY.append(Y)
#     # # Display Plotdata
#     # EventDisplayReady.Clear()
#     # TaskDisplayPlotdata.Start()
#     # EventDisplayReady.Wait()
#     # # debug            TIM.sleep(1.0)
#     global VX, VY, XL, XH, YL, YH
#     global EventDisplayReady
#     # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
#     try:
#         IL = 0
#         IH = len(VX) - 1
#         for I in range(IL, REFRESH_DELTA + IH, REFRESH_DELTA):
#             IA = min(100, I)
#             FrameApplication.tbsPlot2D.Refresh(VX, VY, IL, IA, IH,
#                                                XL, XH, YL, YH)
#             # debug TIM.sleep(1.0)
#         EventDisplayReady.Set()
#     except:
#         pass
#     # debug print('OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
#
