#
#----------------------------------------------------------------------
#   FramePlot2D
#----------------------------------------------------------------------
import tkinter as TKI
# NC from tkinter import ttk as TTK
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg \
   import FigureCanvasTkAgg
#
#----------------------------------------------------------------------
DOTSPERINCH = 100
#
class CFramePlot2D(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent)
        self.FrameParent = frameparent
        self.FrameParent.rowconfigure(0, weight=6)
        self.FrameParent.columnconfigure(0, weight=6)
        self.FrameParent.grid(row=0, column=0, sticky='wnse')
        #
        self.rowconfigure(0, weight=6)
        self.columnconfigure(0, weight=6)
        self.Figure, self.Axes = PLT.subplots(figsize=(800 / DOTSPERINCH,
                                                       800 / DOTSPERINCH),
                                              dpi=DOTSPERINCH)
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self) # not[.FrameParent]!
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='wnse') #
        return
    #
    def Refresh(self, plotdatax0, plotdatay0, plotdatax1, plotdatay1,
                xminimum, xmaximum, yminimum, ymaximum):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        DX = (xmaximum - xminimum) / 10.0
        DY = (ymaximum - yminimum) / 10.0
        self.Axes.set_xlim([xminimum - DX, xmaximum + DX])
        self.Axes.set_ylim([yminimum - DX, ymaximum + DY])
        self.Axes.plot(plotdatax0, plotdatay0, marker='.',
                       color='#4444ff', linestyle='solid', linewidth=1.8)
        self.Axes.plot(plotdatax1, plotdatay1,
                       color='#ff88aa', linestyle='solid', linewidth=1.8)
        # self.Axes.plot(plotdatax[indexactual - 1:indexhigh],
        #                plotdatay[indexactual - 1:indexhigh],
        #                color='#ccccff', linestyle='solid', linewidth=1.8)
        # self.Axes.plot(plotdatax[indexlow:indexactual],
        #                plotdatay[indexlow:indexactual],
        #                color='#ff8888', linestyle='solid', linewidth=1.8)
        self.Canvas.draw()
        return
    #
    def RefreshI(self, plotdatax0, plotdatay0,
                 plotdatax1, plotdatay1, indexlow, indexactual, indexhigh,
                 xminimum, xmaximum, yminimum, ymaximum):
        self.Axes.cla()
        self.Axes.grid("both")
        self.Axes.axis('equal')
        self.Axes.set_aspect('equal', 'box')
        self.Axes.set_xlim([xminimum, xmaximum])
        self.Axes.set_ylim([yminimum, ymaximum])
        self.Axes.plot(plotdatax0, plotdatay0,
                       color='#88ff88', linestyle='solid', linewidth=3.8)
        self.Axes.plot(plotdatax1[indexactual:indexhigh],
                       plotdatay1[indexactual:indexhigh],
                       color='#8888ff', linestyle='solid', linewidth=0.8)
        self.Axes.plot(plotdatax1[indexlow:indexactual],
                       plotdatay1[indexlow:indexactual],
                       color='#ff8888', linestyle='solid', linewidth=3.8)
        self.Canvas.draw()
        return
    #
    #
#
#
############################################################################
        # self.Axes.plot(plotdatax1[indexlow:indexactual],
        #                plotdatay1[indexlow:indexactual],
        #                color='#ffcccc', linestyle='solid', linewidth=1.8)
        # self.Axes.plot(plotdatax1[indexactual - 1:indexhigh],
        #                plotdatay1[indexactual - 1:indexhigh],
        #                color='#ccccff', linestyle='solid', linewidth=1.8)
