#
import Define as DEF
import Helper as HLP
import Command as CMD
import Parameter as PAR
import GCodeList as GLT
#
class CGCodeConverter():
    #
    def __init__(self):
        return
    #--------------------------------------------------------------------
    #   Property
    #--------------------------------------------------------------------
    #--------------------------------------------------------------------
    #   Main - GCodeLines -> GCodeList
    #--------------------------------------------------------------------
    def BuildGParameterlist(self, index, tokenlist):
        Parameterlist = []
        while (index < len(tokenlist)):
            Token = tokenlist[index]
            if (DEF.CODE_X == Token[0]):
                Parameterlist.append(PAR.CXParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Y == Token[0]):
                Parameterlist.append(PAR.CYParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_Z == Token[0]):
                Parameterlist.append(PAR.CZParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_H == Token[0]):
                Parameterlist.append(PAR.CHParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_I == Token[0]):
                Parameterlist.append(PAR.CIParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_J == Token[0]):
                Parameterlist.append(PAR.CJParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_K == Token[0]):
                Parameterlist.append(PAR.CKParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_L == Token[0]):
                Parameterlist.append(PAR.CLParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_N == Token[0]):
                Parameterlist.append(PAR.CNParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_P == Token[0]):
                Parameterlist.append(PAR.CPParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_R == Token[0]):
                Parameterlist.append(PAR.CRParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_S == Token[0]):
                Parameterlist.append(PAR.CSParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_T == Token[0]):
                Parameterlist.append(PAR.CTParameter(Token[1:]))
                index += 1
            elif (DEF.CODE_F == Token[0]):
                Parameterlist.append(PAR.CFParameter(Token[1:]))
                index += 1
            else:
                break;
        return [index, Parameterlist]
    #
    def TokenlistCommandParameter(self, gcodelist, tokenlist, comment):
        # analyse 1. tokenlist 2. comment
        Index = 0
        for Token in tokenlist:
            if (0 < len(Token)):
                if (DEF.CODE_G == Token[0]): # G-Command
                    [Index,  Parameterlist] = self.BuildGParameterlist(1 + Index, tokenlist)
                    GCommand = CMD.CGCommand(Token, Parameterlist, '')
                    if (None == GCommand):
                        HLP.Error('Invalid GCode')
                    else:
                        # debug print(GCommand.Text())
                        gcodelist.append(GCommand)
                elif (DEF.CODE_M == Token[0]): # M-Command
                    [Index,  Parameterlist] = self.BuildGParameterlist(1 + Index, tokenlist)
                    MCommand = CMD.CMCommand(Token, Parameterlist, '')
                    if (None == MCommand):
                        HLP.Error('Invalid MCode')
                    else:
                        # debug print(MCommand.Text())
                        gcodelist.append(MCommand)
        if (0 < len(comment)):
            Comment = CMD.CCommand(0, [], comment)
            # debug print(Comment.Text())
            gcodelist.append(Comment)
        return gcodelist
    #
    def ReadFromFile(self, filename):
        FileCommand = open(filename, 'r')
        GCodeLines = FileCommand.readlines()
        # debug print('###########' , GCodeLines)
        Tokenlist = None
        GCodeList = GLT.CGCodeList()
        for GCodeLine in GCodeLines:
            GCodeLine = GCodeLine.strip()
            if (0 < len(GCodeLine)):
                Comment = ''
                SP = GCodeLine.find(';') # search comment
                if (0 <= SP):
                    Comment = GCodeLine[SP:]
                    GCodeLine = GCodeLine[0:SP]
                Tokenlist = GCodeLine.strip().split(' ')
                # debug print(Tokenlist, ' | ', Comment)
                GCodeList = self.TokenlistCommandParameter(GCodeList, Tokenlist, Comment)
        # debug print('###########', GCodeList)
        return [GCodeList, GCodeLines]
    #
    #
#
#
